/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import com.navercorp.pinpoint.profiler.plugin.PluginConfig;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLClassLoaderHandler
implements ClassInjector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private static final Method ADD_URL;
    private final PluginConfig pluginConfig;
    private final BootstrapCore bootstrapCore;

    public URLClassLoaderHandler(PluginConfig pluginConfig, BootstrapCore bootstrapCore) {
        this.pluginConfig = (PluginConfig)Assert.requireNonNull((Object)pluginConfig, (String)"pluginConfig must not be null");
        this.bootstrapCore = (BootstrapCore)Assert.requireNonNull((Object)bootstrapCore, (String)"bootstrapCore must not be null");
    }

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                this.addPluginURLIfAbsent(urlClassLoader);
                return urlClassLoader.loadClass(className);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin class {} with classLoader {}", new Object[]{className, classLoader, e});
            throw new PinpointException("Failed to load plugin class " + className + " with classLoader " + classLoader, (Throwable)e);
        }
        throw new PinpointException("invalid ClassLoader");
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        try {
            if (targetClassLoader instanceof URLClassLoader) {
                if (this.bootstrapCore.isBootstrapPackageByInternalName(internalName)) {
                    return this.bootstrapCore.openStream(internalName);
                }
                URLClassLoader urlClassLoader = (URLClassLoader)targetClassLoader;
                this.addPluginURLIfAbsent(urlClassLoader);
                return targetClassLoader.getResourceAsStream(internalName);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load plugin resource as stream {} with classLoader {}", new Object[]{internalName, targetClassLoader, e});
            return null;
        }
        return null;
    }

    private void addPluginURLIfAbsent(URLClassLoader classLoader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean hasPluginJar;
        URL[] urls = classLoader.getURLs();
        if (urls != null && !(hasPluginJar = this.hasPluginJar(urls))) {
            if (this.isDebug) {
                this.logger.debug("add Jar:{}", (Object)this.pluginConfig.getPluginJarURLExternalForm());
            }
            ADD_URL.invoke((Object)classLoader, this.pluginConfig.getPluginJar());
        }
    }

    private boolean hasPluginJar(URL[] urls) {
        for (URL url : urls) {
            String externalForm = url.toExternalForm();
            if (!this.pluginConfig.getPluginJarURLExternalForm().equals(externalForm)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            ADD_URL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot access URLClassLoader.addURL(URL)", e);
        }
    }
}

