/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.jvmgc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DefaultDetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.GarbageCollectorType;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.UnknownDetailedGarbageCollectorMetric;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedGarbageCollectorMetricProvider
implements Provider<DetailedGarbageCollectorMetric> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public DetailedGarbageCollectorMetricProvider() {
    }

    public DetailedGarbageCollectorMetric get() {
        DetailedGarbageCollectorMetric detailedGarbageCollectorMetric = null;
        Map<String, GarbageCollectorMXBean> garbageCollectorMap = this.createGarbageCollectorMap();
        for (GarbageCollectorType garbageCollectorType : GarbageCollectorType.values()) {
            if (!garbageCollectorMap.containsKey(garbageCollectorType.oldGenName())) continue;
            GarbageCollectorMXBean garbageCollectorMXBean = garbageCollectorMap.get(garbageCollectorType.oldGenName());
            detailedGarbageCollectorMetric = new DefaultDetailedGarbageCollectorMetric(garbageCollectorType, garbageCollectorMXBean);
            break;
        }
        if (detailedGarbageCollectorMetric == null) {
            detailedGarbageCollectorMetric = new UnknownDetailedGarbageCollectorMetric();
        }
        this.logger.info("loaded : {}", (Object)detailedGarbageCollectorMetric);
        return detailedGarbageCollectorMetric;
    }

    private Map<String, GarbageCollectorMXBean> createGarbageCollectorMap() {
        HashMap<String, GarbageCollectorMXBean> garbageCollectorMap = new HashMap<String, GarbageCollectorMXBean>();
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : garbageCollectorMXBeans) {
            garbageCollectorMap.put(garbageCollectorMXBean.getName(), garbageCollectorMXBean);
        }
        return garbageCollectorMap;
    }
}

