/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor;

import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitor;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorWrapperFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceMonitorRegistryService
implements DataSourceMonitorRegistryService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int limitIdNumber;
    private final CopyOnWriteArrayList<DataSourceMonitorWrapper> repository = new CopyOnWriteArrayList();
    private final DataSourceMonitorWrapperFactory wrapperFactory = new DataSourceMonitorWrapperFactory();

    public DefaultDataSourceMonitorRegistryService(int limitIdNumber) {
        this.limitIdNumber = limitIdNumber;
    }

    @Override
    public boolean register(DataSourceMonitor dataSourceMonitor) {
        if (this.wrapperFactory.latestIssuedId() >= this.limitIdNumber) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("can't register {}. The maximum value of id number has been exceeded.");
            }
            return false;
        }
        DataSourceMonitorWrapper dataSourceMonitorWrapper = this.wrapperFactory.create(dataSourceMonitor);
        return this.repository.add(dataSourceMonitorWrapper);
    }

    @Override
    public boolean unregister(DataSourceMonitor dataSourceMonitor) {
        for (DataSourceMonitorWrapper dataSourceMonitorWrapper : this.repository) {
            if (!dataSourceMonitorWrapper.equalsWithUnwrap(dataSourceMonitor)) continue;
            return this.repository.remove(dataSourceMonitorWrapper);
        }
        return false;
    }

    @Override
    public List<DataSourceMonitorWrapper> getPluginMonitorWrapperList() {
        ArrayList<DataSourceMonitorWrapper> pluginMonitorList = new ArrayList<DataSourceMonitorWrapper>(this.repository.size());
        ArrayList<DataSourceMonitorWrapper> disabledPluginMonitorList = new ArrayList<DataSourceMonitorWrapper>();
        for (DataSourceMonitorWrapper dataSourceMonitorWrapper : this.repository) {
            if (dataSourceMonitorWrapper.isDisabled()) {
                disabledPluginMonitorList.add(dataSourceMonitorWrapper);
                continue;
            }
            pluginMonitorList.add(dataSourceMonitorWrapper);
        }
        if (disabledPluginMonitorList.size() > 0) {
            this.logger.info("PluginMonitorWrapper was disabled(list:{})", disabledPluginMonitorList);
            this.repository.removeAll(disabledPluginMonitorList);
        }
        return pluginMonitorList;
    }

    @Override
    public int getRemainingIdNumber() {
        return this.limitIdNumber - this.wrapperFactory.latestIssuedId();
    }
}

