/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module.config;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.module.BootstrapJarPaths;
import com.navercorp.pinpoint.profiler.context.module.Container;
import com.navercorp.pinpoint.profiler.context.module.PluginJars;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorEnable;
import com.navercorp.pinpoint.profiler.context.module.config.DeadlockMonitorInterval;
import com.navercorp.pinpoint.profiler.context.module.config.TraceAgentActiveThread;
import com.navercorp.pinpoint.profiler.context.provider.AgentStartTimeProvider;
import com.navercorp.pinpoint.profiler.context.provider.InterceptorRegistryBinderProvider;
import com.navercorp.pinpoint.profiler.instrument.classloading.BootstrapCore;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AgentOption agentOption;

    public ConfigModule(AgentOption agentOption) {
        this.agentOption = (AgentOption)Assert.requireNonNull((Object)agentOption, (String)"profilerConfig must not be null");
        Assert.requireNonNull((Object)agentOption.getProfilerConfig(), (String)"profilerConfig must not be null");
    }

    protected void configure() {
        this.binder().requireExplicitBindings();
        this.binder().requireAtInjectOnConstructors();
        this.binder().disableCircularProxies();
        ProfilerConfig profilerConfig = this.agentOption.getProfilerConfig();
        this.bind(ProfilerConfig.class).toInstance((Object)profilerConfig);
        this.bindConstants(profilerConfig);
        this.bind(Instrumentation.class).toInstance((Object)this.agentOption.getInstrumentation());
        this.bind(InterceptorRegistryBinder.class).toProvider(InterceptorRegistryBinderProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<List<String>> pluginJarFile = new TypeLiteral<List<String>>(){};
        this.bind((TypeLiteral)pluginJarFile).annotatedWith(PluginJars.class).toInstance((Object)this.agentOption.getPluginJars());
        this.bindBootstrapCoreInformation();
        this.bindAgentInformation(this.agentOption.getAgentId(), this.agentOption.getApplicationName(), this.agentOption.isContainer());
    }

    private void bindBootstrapCoreInformation() {
        List bootstrapJarPaths = this.agentOption.getBootstrapJarPaths();
        TypeLiteral<List<String>> bootstrapJarFIle = new TypeLiteral<List<String>>(){};
        this.bind((TypeLiteral)bootstrapJarFIle).annotatedWith(BootstrapJarPaths.class).toInstance((Object)bootstrapJarPaths);
        BootstrapCore bootstrapCore = new BootstrapCore(bootstrapJarPaths);
        this.bind(BootstrapCore.class).toInstance((Object)bootstrapCore);
    }

    private void bindConstants(ProfilerConfig profilerConfig) {
        TraceDataFormatVersion version = TraceDataFormatVersion.getTraceDataFormatVersion(profilerConfig);
        this.logger.info("TraceDataFormatVersion:{}", (Object)version);
        this.bind(TraceDataFormatVersion.class).toInstance((Object)version);
        Named callstackMaxDepth = Names.named((String)"profiler.callstack.max.depth");
        this.bindConstant().annotatedWith((Annotation)callstackMaxDepth).to(profilerConfig.getCallStackMaxDepth());
        this.bindConstant().annotatedWith(TraceAgentActiveThread.class).to(profilerConfig.isTraceAgentActiveThread());
        this.bindConstant().annotatedWith(DeadlockMonitorEnable.class).to(profilerConfig.isDeadlockMonitorEnable());
        this.bindConstant().annotatedWith(DeadlockMonitorInterval.class).to(profilerConfig.getDeadlockMonitorInterval());
    }

    private void bindAgentInformation(String agentId, String applicationName, boolean isContainer) {
        this.bind(String.class).annotatedWith(AgentId.class).toInstance((Object)agentId);
        this.bind(String.class).annotatedWith(ApplicationName.class).toInstance((Object)applicationName);
        this.bind(Boolean.class).annotatedWith(Container.class).toInstance((Object)isContainer);
        this.bind(Long.class).annotatedWith(AgentStartTime.class).toProvider(AgentStartTimeProvider.class).in(Scopes.SINGLETON);
    }
}

