/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.DefaultFrameAttachment;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import java.util.ArrayList;
import java.util.List;

public class SpanEvent
extends DefaultFrameAttachment {
    private boolean timeRecording = true;
    private int stackId;
    private long startTime;
    private int elapsedTime;
    private short sequence;
    private short serviceType;
    private String endPoint;
    private List<Annotation> annotations;
    private int depth = -1;
    private long nextSpanId = -1L;
    private String destinationId;
    private int apiId;
    private IntStringValue exceptionInfo;
    private AsyncId asyncIdObject;
    private LocalAsyncId localAsyncId;

    public void addAnnotation(Annotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<Annotation>();
        }
        this.annotations.add(annotation);
    }

    public void setExceptionInfo(int exceptionClassId, String exceptionMessage) {
        IntStringValue exceptionInfo;
        this.exceptionInfo = exceptionInfo = new IntStringValue(exceptionClassId, exceptionMessage);
    }

    public void markStartTime() {
        this.setStartTime(System.currentTimeMillis());
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void markAfterTime() {
        this.checkStartTime();
        this.setAfterTime(System.currentTimeMillis());
    }

    public void setAfterTime(long afterTime) {
        this.checkStartTime();
        this.elapsedTime = (int)(afterTime - this.startTime);
    }

    private void checkStartTime() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("startTime not recorded");
        }
    }

    public long getAfterTime() {
        return this.startTime + (long)this.elapsedTime;
    }

    public int getStackId() {
        return this.stackId;
    }

    public void setStackId(int stackId) {
        this.stackId = stackId;
    }

    public boolean isTimeRecording() {
        return this.timeRecording;
    }

    public void setTimeRecording(boolean timeRecording) {
        this.timeRecording = timeRecording;
    }

    public short getSequence() {
        return this.sequence;
    }

    public void setSequence(short sequence) {
        this.sequence = sequence;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    @Deprecated
    public String getRpc() {
        return null;
    }

    @Deprecated
    public void setRpc(String rpc) {
    }

    public short getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(short serviceType) {
        this.serviceType = serviceType;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public long getNextSpanId() {
        return this.nextSpanId;
    }

    public void setNextSpanId(long nextSpanId) {
        this.nextSpanId = nextSpanId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public IntStringValue getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionInfo(IntStringValue exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public LocalAsyncId getLocalAsyncId() {
        return this.localAsyncId;
    }

    public void setLocalAsyncId(LocalAsyncId localAsyncId) {
        this.localAsyncId = localAsyncId;
    }

    public void setAsyncIdObject(AsyncId asyncIdObject) {
        this.asyncIdObject = asyncIdObject;
    }

    public AsyncId getAsyncIdObject() {
        return this.asyncIdObject;
    }

    public String toString() {
        return "SpanEvent{stackId=" + this.stackId + ", timeRecording=" + this.timeRecording + ", startTime=" + this.startTime + ", elapsedTime=" + this.elapsedTime + ", asyncIdObject=" + this.asyncIdObject + ", sequence=" + this.sequence + ", serviceType=" + this.serviceType + ", endPoint='" + this.endPoint + '\'' + ", annotations=" + this.annotations + ", depth=" + this.depth + ", nextSpanId=" + this.nextSpanId + ", destinationId='" + this.destinationId + '\'' + ", apiId=" + this.apiId + ", exceptionInfo=" + this.exceptionInfo + ", localAsyncId=" + this.localAsyncId + "} ";
    }
}

