/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.cpu.oracle;

import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuUsageProvider;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCpuLoadMetric
implements CpuLoadMetric {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CpuUsageProvider jvmCpuUsageProvider;
    private final CpuUsageProvider systemCpuUsageProvider;

    public DefaultCpuLoadMetric() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean == null) {
            throw new IllegalStateException("OperatingSystemMXBean not available");
        }
        JvmCpuUsageProvider jvmCpuUsageProvider = new JvmCpuUsageProvider(operatingSystemMXBean);
        try {
            jvmCpuUsageProvider.getCpuUsage();
        }
        catch (NoSuchMethodError e) {
            this.logger.warn("Expected method not found for retrieving jvm cpu usage. Cause : {}", (Object)e.getMessage());
            jvmCpuUsageProvider = CpuUsageProvider.UNSUPPORTED;
        }
        this.jvmCpuUsageProvider = jvmCpuUsageProvider;
        SystemCpuUsageProvider systemCpuUsageProvider = new SystemCpuUsageProvider(operatingSystemMXBean);
        try {
            systemCpuUsageProvider.getCpuUsage();
        }
        catch (NoSuchMethodError e) {
            this.logger.warn("Expected method not found for retrieving system cpu usage. Cause : {}", (Object)e.getMessage());
            systemCpuUsageProvider = CpuUsageProvider.UNSUPPORTED;
        }
        this.systemCpuUsageProvider = systemCpuUsageProvider;
    }

    public CpuLoadMetricSnapshot getSnapshot() {
        double jvmCpuUsage = this.jvmCpuUsageProvider.getCpuUsage();
        double systemCpuUsage = this.systemCpuUsageProvider.getCpuUsage();
        return new CpuLoadMetricSnapshot(jvmCpuUsage, systemCpuUsage);
    }

    public String toString() {
        return "CpuLoadMetric for Oracle Java 1.7+";
    }

    private static class SystemCpuUsageProvider
    implements CpuUsageProvider {
        private final OperatingSystemMXBean operatingSystemMXBean;

        private SystemCpuUsageProvider(OperatingSystemMXBean operatingSystemMXBean) {
            this.operatingSystemMXBean = operatingSystemMXBean;
        }

        public double getCpuUsage() {
            return this.operatingSystemMXBean.getSystemCpuLoad();
        }
    }

    private static class JvmCpuUsageProvider
    implements CpuUsageProvider {
        private final OperatingSystemMXBean operatingSystemMXBean;

        private JvmCpuUsageProvider(OperatingSystemMXBean operatingSystemMXBean) {
            this.operatingSystemMXBean = operatingSystemMXBean;
        }

        public double getCpuUsage() {
            return this.operatingSystemMXBean.getProcessCpuLoad();
        }
    }
}

