#!/bin/bash
echo "java_start java"
module_name=project
package_path="./${module_name}/app.jar"
config_path="./${module_name}/application.properties"

namespace=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "namespace is $namespace"
sed -i "s/.xyqb.com/-$namespace.q-gp.com/g" ${config_path}

echo "java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Denv=dev -Didc=k8s -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} -Djava.security.egd=file:/dev/./urandom" > java_command
nohup java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Denv=dev -Didc=k8s -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} -Djava.security.egd=file:/dev/./urandom &

echo "sleep 10"
sleep 10

if ls ./*log 1> /dev/null 2>&1; then
    echo "ls -l ./logs"
    ls -l ./logs    
else
    echo "files do not exist"
    touch ./logs/tmp.log
fi

echo "node /home/demoXterm/demo/app.js"
nohup node /home/demoXterm/demo/app.js &

echo "frontail logs/*.log -d -n 1000"
frontail ./logs/*log -n 1000