/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsetConfiguration
extends AbstractConfiguration {
    protected Configuration parent;
    protected String prefix;
    protected String delimiter;

    public SubsetConfiguration(Configuration configuration, String string) {
        this.parent = configuration;
        this.prefix = string;
    }

    public SubsetConfiguration(Configuration configuration, String string, String string2) {
        this.parent = configuration;
        this.prefix = string;
        this.delimiter = string2;
    }

    protected String getParentKey(String string) {
        if ("".equals(string) || string == null) {
            return this.prefix;
        }
        return this.delimiter == null ? this.prefix + string : this.prefix + this.delimiter + string;
    }

    protected String getChildKey(String string) {
        if (!string.startsWith(this.prefix)) {
            throw new IllegalArgumentException("The parent key '" + string + "' is not in the subset.");
        }
        String string2 = null;
        if (string.length() == this.prefix.length()) {
            string2 = "";
        } else {
            int n = this.prefix.length() + (this.delimiter != null ? this.delimiter.length() : 0);
            string2 = string.substring(n);
        }
        return string2;
    }

    public Configuration getParent() {
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public Configuration subset(String string) {
        return this.parent.subset(this.getParentKey(string));
    }

    @Override
    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    @Override
    public boolean containsKey(String string) {
        return this.parent.containsKey(this.getParentKey(string));
    }

    @Override
    public void addPropertyDirect(String string, Object object) {
        this.parent.addProperty(this.getParentKey(string), object);
    }

    @Override
    protected void clearPropertyDirect(String string) {
        this.parent.clearProperty(this.getParentKey(string));
    }

    @Override
    public Object getProperty(String string) {
        return this.parent.getProperty(this.getParentKey(string));
    }

    @Override
    public Iterator<String> getKeys(String string) {
        return new SubsetIterator(this.parent.getKeys(this.getParentKey(string)));
    }

    @Override
    public Iterator<String> getKeys() {
        return new SubsetIterator(this.parent.getKeys(this.prefix));
    }

    @Override
    protected Object interpolate(Object object) {
        if (this.delimiter == null && "".equals(this.prefix)) {
            return super.interpolate(object);
        }
        SubsetConfiguration subsetConfiguration = new SubsetConfiguration(this.parent, "");
        ConfigurationInterpolator configurationInterpolator = subsetConfiguration.getInterpolator();
        this.getInterpolator().registerLocalLookups(configurationInterpolator);
        if (this.parent instanceof AbstractConfiguration) {
            configurationInterpolator.setParentInterpolator(((AbstractConfiguration)this.parent).getInterpolator());
        }
        return subsetConfiguration.interpolate(object);
    }

    @Override
    protected String interpolate(String string) {
        return super.interpolate(string);
    }

    @Override
    public void setThrowExceptionOnMissing(boolean bl) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setThrowExceptionOnMissing(bl);
        } else {
            super.setThrowExceptionOnMissing(bl);
        }
    }

    @Override
    public boolean isThrowExceptionOnMissing() {
        if (this.parent instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)this.parent).isThrowExceptionOnMissing();
        }
        return super.isThrowExceptionOnMissing();
    }

    @Override
    public char getListDelimiter() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).getListDelimiter() : super.getListDelimiter();
    }

    @Override
    public void setListDelimiter(char c2) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setListDelimiter(c2);
        } else {
            super.setListDelimiter(c2);
        }
    }

    @Override
    public boolean isDelimiterParsingDisabled() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).isDelimiterParsingDisabled() : super.isDelimiterParsingDisabled();
    }

    @Override
    public void setDelimiterParsingDisabled(boolean bl) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setDelimiterParsingDisabled(bl);
        } else {
            super.setDelimiterParsingDisabled(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubsetIterator
    implements Iterator<String> {
        private final Iterator<String> parentIterator;

        public SubsetIterator(Iterator<String> iterator) {
            this.parentIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public String next() {
            return SubsetConfiguration.this.getChildKey(this.parentIterator.next());
        }

        @Override
        public void remove() {
            this.parentIterator.remove();
        }
    }
}

