/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.lang.text;

import com.secnium.iast.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.Validate;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.FormatFactory;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrBuilder;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrMatcher;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final String ESCAPED_QUOTE = "''";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map registry;

    public ExtendedMessageFormat(String string) {
        this(string, Locale.getDefault());
    }

    public ExtendedMessageFormat(String string, Locale locale) {
        this(string, locale, null);
    }

    public ExtendedMessageFormat(String string, Map map) {
        this(string, Locale.getDefault(), map);
    }

    public ExtendedMessageFormat(String string, Locale locale, Map map) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = map;
        this.applyPattern(string);
    }

    public String toPattern() {
        return this.toPattern;
    }

    public final void applyPattern(String string) {
        Object object;
        Object object2;
        int n;
        if (this.registry == null) {
            super.applyPattern(string);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        StrBuilder strBuilder = new StrBuilder(string.length());
        ParsePosition parsePosition = new ParsePosition(0);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        block4: while (parsePosition.getIndex() < string.length()) {
            switch (cArray[parsePosition.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(string, parsePosition, strBuilder, true);
                    continue block4;
                }
                case '{': {
                    ++n2;
                    this.seekNonWs(string, parsePosition);
                    int n3 = parsePosition.getIndex();
                    n = this.readArgumentIndex(string, this.next(parsePosition));
                    strBuilder.append('{').append(n);
                    this.seekNonWs(string, parsePosition);
                    object2 = null;
                    object = null;
                    if (cArray[parsePosition.getIndex()] == ',' && (object2 = this.getFormat((String)(object = this.parseFormatDescription(string, this.next(parsePosition))))) == null) {
                        strBuilder.append(',').append((String)object);
                    }
                    arrayList.add(object2);
                    arrayList2.add(object2 == null ? null : object);
                    Validate.isTrue(arrayList.size() == n2);
                    Validate.isTrue(arrayList2.size() == n2);
                    if (cArray[parsePosition.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + n3);
                }
            }
            strBuilder.append(cArray[parsePosition.getIndex()]);
            this.next(parsePosition);
        }
        super.applyPattern(strBuilder.toString());
        this.toPattern = this.insertFormats(super.toPattern(), arrayList2);
        if (this.containsElements(arrayList)) {
            Format[] formatArray = this.getFormats();
            n = 0;
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (Format)object2.next();
                if (object != null) {
                    formatArray[n] = object;
                }
                ++n;
            }
            super.setFormats(formatArray);
        }
    }

    public void setFormat(int n, Format format) {
        throw new UnsupportedOperationException();
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        throw new UnsupportedOperationException();
    }

    public void setFormats(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (ObjectUtils.notEqual(this.getClass(), object.getClass())) {
            return false;
        }
        ExtendedMessageFormat extendedMessageFormat = (ExtendedMessageFormat)object;
        if (ObjectUtils.notEqual(this.toPattern, extendedMessageFormat.toPattern)) {
            return false;
        }
        return !ObjectUtils.notEqual(this.registry, extendedMessageFormat.registry);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + ObjectUtils.hashCode(this.registry);
        n = 31 * n + ObjectUtils.hashCode(this.toPattern);
        return n;
    }

    private Format getFormat(String string) {
        if (this.registry != null) {
            FormatFactory formatFactory;
            String string2 = string;
            String string3 = null;
            int n = string.indexOf(44);
            if (n > 0) {
                string2 = string.substring(0, n).trim();
                string3 = string.substring(n + 1).trim();
            }
            if ((formatFactory = (FormatFactory)this.registry.get(string2)) != null) {
                return formatFactory.getFormat(string2, string3, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String var1_1, ParsePosition var2_2) {
        var3_3 = var2_2.getIndex();
        this.seekNonWs(var1_1, var2_2);
        var4_4 = new StrBuilder();
        var5_5 = false;
        while (!var5_5 && var2_2.getIndex() < var1_1.length()) {
            var6_6 = var1_1.charAt(var2_2.getIndex());
            if (!Character.isWhitespace(var6_6)) ** GOTO lbl-1000
            this.seekNonWs(var1_1, var2_2);
            var6_6 = var1_1.charAt(var2_2.getIndex());
            if (var6_6 != ',' && var6_6 != '}') {
                var5_5 = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((var6_6 == ',' || var6_6 == '}') && var4_4.length() > 0) {
                    try {
                        return Integer.parseInt(var4_4.toString());
                    }
                    catch (NumberFormatException var7_7) {
                        // empty catch block
                    }
                }
                var5_5 = Character.isDigit(var6_6) == false;
                var4_4.append(var6_6);
            }
            this.next(var2_2);
        }
        if (var5_5) {
            throw new IllegalArgumentException("Invalid format argument index at position " + var3_3 + ": " + var1_1.substring(var3_3, var2_2.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + var3_3);
    }

    private String parseFormatDescription(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        this.seekNonWs(string, parsePosition);
        int n2 = parsePosition.getIndex();
        int n3 = 1;
        while (parsePosition.getIndex() < string.length()) {
            switch (string.charAt(parsePosition.getIndex())) {
                case '{': {
                    ++n3;
                    break;
                }
                case '}': {
                    if (--n3 != 0) break;
                    return string.substring(n2, parsePosition.getIndex());
                }
                case '\'': {
                    this.getQuotedString(string, parsePosition, false);
                }
            }
            this.next(parsePosition);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + n);
    }

    private String insertFormats(String string, ArrayList arrayList) {
        if (!this.containsElements(arrayList)) {
            return string;
        }
        StrBuilder strBuilder = new StrBuilder(string.length() * 2);
        ParsePosition parsePosition = new ParsePosition(0);
        int n = -1;
        int n2 = 0;
        block5: while (parsePosition.getIndex() < string.length()) {
            char c2 = string.charAt(parsePosition.getIndex());
            switch (c2) {
                case '\'': {
                    this.appendQuotedString(string, parsePosition, strBuilder, false);
                    break;
                }
                case '{': {
                    String string2;
                    if (++n2 != 1) continue block5;
                    strBuilder.append('{').append(this.readArgumentIndex(string, this.next(parsePosition)));
                    if ((string2 = (String)arrayList.get(++n)) == null) continue block5;
                    strBuilder.append(',').append(string2);
                    break;
                }
                case '}': {
                    --n2;
                }
                default: {
                    strBuilder.append(c2);
                    this.next(parsePosition);
                }
            }
        }
        return strBuilder.toString();
    }

    private void seekNonWs(String string, ParsePosition parsePosition) {
        int n = 0;
        char[] cArray = string.toCharArray();
        do {
            n = StrMatcher.splitMatcher().isMatch(cArray, parsePosition.getIndex());
            parsePosition.setIndex(parsePosition.getIndex() + n);
        } while (n > 0 && parsePosition.getIndex() < string.length());
    }

    private ParsePosition next(ParsePosition parsePosition) {
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        return parsePosition;
    }

    private StrBuilder appendQuotedString(String string, ParsePosition parsePosition, StrBuilder strBuilder, boolean bl) {
        int n = parsePosition.getIndex();
        char[] cArray = string.toCharArray();
        if (bl && cArray[n] == '\'') {
            this.next(parsePosition);
            return strBuilder == null ? null : strBuilder.append('\'');
        }
        int n2 = n;
        for (int i = parsePosition.getIndex(); i < string.length(); ++i) {
            if (bl && string.substring(i).startsWith(ESCAPED_QUOTE)) {
                strBuilder.append(cArray, n2, parsePosition.getIndex() - n2).append('\'');
                parsePosition.setIndex(i + ESCAPED_QUOTE.length());
                n2 = parsePosition.getIndex();
                continue;
            }
            switch (cArray[parsePosition.getIndex()]) {
                case '\'': {
                    this.next(parsePosition);
                    return strBuilder == null ? null : strBuilder.append(cArray, n2, parsePosition.getIndex() - n2);
                }
            }
            this.next(parsePosition);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + n);
    }

    private void getQuotedString(String string, ParsePosition parsePosition, boolean bl) {
        this.appendQuotedString(string, parsePosition, null, bl);
    }

    private boolean containsElements(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            return true;
        }
        return false;
    }
}

