/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.CallStackFactoryV1;
import com.navercorp.pinpoint.profiler.context.CallStackFactoryV2;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;

public class CallStackFactoryProvider
implements Provider<CallStackFactory<SpanEvent>> {
    private final TraceDataFormatVersion version;
    private final int callStackMaxDepth;

    @Inject
    public CallStackFactoryProvider(@Named(value="profiler.callstack.max.depth") int callStackMaxDepth, TraceDataFormatVersion version) {
        this.version = (TraceDataFormatVersion)((Object)Assert.requireNonNull((Object)((Object)version), (String)"version must not be null"));
        this.callStackMaxDepth = callStackMaxDepth;
    }

    public CallStackFactory<SpanEvent> get() {
        if (this.version == TraceDataFormatVersion.V2) {
            return new CallStackFactoryV2(this.callStackMaxDepth);
        }
        if (this.version == TraceDataFormatVersion.V1) {
            return new CallStackFactoryV1(this.callStackMaxDepth);
        }
        throw new UnsupportedOperationException("unknown version :" + (Object)((Object)this.version));
    }
}

