/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.postgresql;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.StringMaker;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.jdbc.postgresql.PostgreSqlConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PostgreSqlJdbcUrlParser
implements JdbcUrlParserV2 {
    private static final String URL_PREFIX = "jdbc:postgresql:";
    private static final String LOADBALANCE_URL_PREFIX = "jdbc:postgresql:loadbalance:";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl must not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(URL_PREFIX)) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            this.logger.info("PostgreJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase((ServiceType)PostgreSqlConstants.POSTGRESQL, (ServiceType)PostgreSqlConstants.POSTGRESQL_EXECUTE_QUERY, (String)jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String url) {
        if (this.isLoadbalanceUrl(url)) {
            return this.parseLoadbalancedUrl(url);
        }
        return this.parseNormal(url);
    }

    private DatabaseInfo parseLoadbalancedUrl(String url) {
        StringMaker maker = new StringMaker(url);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        String[] parsedHost = host.split(",");
        List<String> hostList = Arrays.asList(parsedHost);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(PostgreSqlConstants.POSTGRESQL, PostgreSqlConstants.POSTGRESQL_EXECUTE_QUERY, url, normalizedUrl, hostList, databaseId);
    }

    private boolean isLoadbalanceUrl(String url) {
        return url.regionMatches(true, 0, LOADBALANCE_URL_PREFIX, 0, LOADBALANCE_URL_PREFIX.length());
    }

    private DatabaseInfo parseNormal(String url) {
        StringMaker maker = new StringMaker(url);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(PostgreSqlConstants.POSTGRESQL, PostgreSqlConstants.POSTGRESQL_EXECUTE_QUERY, url, normalizedUrl, hostList, databaseId);
    }

    public ServiceType getServiceType() {
        return PostgreSqlConstants.POSTGRESQL;
    }
}

