/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.io.request;

import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.request.DefaultAttributeMap;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.io.request.ServerRequest;

public class DefaultServerRequest<T>
extends DefaultAttributeMap
implements ServerRequest<T> {
    private final Message<T> message;
    private final String remoteAddress;
    private final int remotePort;

    public DefaultServerRequest(Message<T> message, String remoteAddress, int remotePort) {
        if (message == null) {
            throw new NullPointerException("message must not be null");
        }
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress must not be null");
        }
        this.message = message;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
    }

    @Override
    public Header getHeader() {
        return this.message.getHeader();
    }

    @Override
    public HeaderEntity getHeaderEntity() {
        return this.message.getHeaderEntity();
    }

    @Override
    public T getData() {
        return this.message.getData();
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    public String toString() {
        return "DefaultServerRequest{message=" + this.message + ", remoteAddress='" + this.remoteAddress + '\'' + ", remotePort=" + this.remotePort + '}';
    }
}

