/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class HttpClient4PluginConfig {
    private boolean param = true;
    private boolean statusCode = true;
    private boolean io;
    private HttpDumpConfig httpDumpConfig;

    public HttpClient4PluginConfig(ProfilerConfig src) {
        this.param = src.readBoolean("profiler.apache.httpclient4.param", true);
        boolean cookie = src.readBoolean("profiler.apache.httpclient4.cookie", false);
        DumpType cookieDumpType = src.readDumpType("profiler.apache.httpclient4.cookie.dumptype", DumpType.EXCEPTION);
        int cookieSamplingRate = src.readInt("profiler.apache.httpclient4.cookie.sampling.rate", 1);
        int cookieDumpSize = src.readInt("profiler.apache.httpclient4.cookie.dumpsize", 1024);
        boolean entity = src.readBoolean("profiler.apache.httpclient4.entity", false);
        DumpType entityDumpType = src.readDumpType("profiler.apache.httpclient4.entity.dumptype", DumpType.EXCEPTION);
        int entitySamplingRate = src.readInt("profiler.apache.httpclient4.entity.sampling.rate", 1);
        int entityDumpSize = src.readInt("profiler.apache.httpclient4.entity.dumpsize", 1024);
        this.httpDumpConfig = HttpDumpConfig.get((boolean)cookie, (DumpType)cookieDumpType, (int)cookieSamplingRate, (int)cookieDumpSize, (boolean)entity, (DumpType)entityDumpType, (int)entitySamplingRate, (int)entityDumpSize);
        this.statusCode = src.readBoolean("profiler.apache.httpclient4.entity.statuscode", true);
        this.io = src.readBoolean("profiler.apache.httpclient4.io", true);
    }

    public boolean isParam() {
        return this.param;
    }

    public boolean isStatusCode() {
        return this.statusCode;
    }

    public boolean isIo() {
        return this.io;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpClient4PluginConfig{");
        sb.append("param=").append(this.param);
        sb.append(", statusCode=").append(this.statusCode);
        sb.append(", io=").append(this.io);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append('}');
        return sb.toString();
    }
}

