/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4;

import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;

public final class EndPointUtils {
    private EndPointUtils() {
    }

    public static String getHostAndPort(HttpRoute route) {
        HttpHost proxyHost = route.getProxyHost();
        if (proxyHost != null) {
            String hostName = proxyHost.getHostName();
            int port = HostAndPort.getPortOrNoPort((int)proxyHost.getPort());
            return HostAndPort.toHostAndPortString((String)hostName, (int)port);
        }
        HttpHost targetHost = route.getTargetHost();
        if (targetHost != null) {
            String hostName = targetHost.getHostName();
            int port = HostAndPort.getPortOrNoPort((int)targetHost.getPort());
            return HostAndPort.toHostAndPortString((String)hostName, (int)port);
        }
        return "";
    }
}

