/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.tprotocol.server;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.AsyncMarkerFlagFieldAccessor;
import org.apache.thrift.protocol.TMessage;

public class TProtocolReadMessageBeginInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final InterceptorScope scope;

    public TProtocolReadMessageBeginInterceptor(InterceptorScope scope) {
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (!this.validate(target)) {
            return;
        }
        boolean shouldTrace = ((AsyncMarkerFlagFieldAccessor)target)._$PINPOINT$_getAsyncMarkerFlag();
        if (shouldTrace) {
            String methodName = "unknown";
            if (result instanceof TMessage) {
                TMessage message = (TMessage)result;
                methodName = message.name;
            }
            ThriftClientCallContext clientCallContext = new ThriftClientCallContext(methodName);
            InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
            currentTransaction.setAttachment((Object)clientCallContext);
        }
    }

    private boolean validate(Object target) {
        if (!(target instanceof AsyncMarkerFlagFieldAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)AsyncMarkerFlagFieldAccessor.class.getName());
            }
            return false;
        }
        return true;
    }
}

