/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.kafka.field.accessor.RemoteAddressFieldAccessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class ConsumerRecordsDesc {
    private final Set<String> topicSet;
    private final String remoteAddress;
    private final int size;

    private ConsumerRecordsDesc(Set<String> topicSet, String remoteAddress, int size) {
        this.topicSet = topicSet;
        this.remoteAddress = remoteAddress;
        this.size = size;
    }

    String getTopicString() {
        if (CollectionUtils.isEmpty(this.topicSet)) {
            return "Unknown";
        }
        if (CollectionUtils.nullSafeSize(this.topicSet) == 1) {
            return this.topicSet.iterator().next();
        }
        return this.topicSet.toString();
    }

    String getRemoteAddress() {
        if (this.remoteAddress == null) {
            return "Unknown";
        }
        return this.remoteAddress;
    }

    int size() {
        return this.size;
    }

    static ConsumerRecordsDesc create(Object object) {
        if (object instanceof Iterable) {
            return ConsumerRecordsDesc.create(((Iterable)object).iterator());
        }
        return null;
    }

    static ConsumerRecordsDesc create(Iterator consumerRecordIterator) {
        HashSet<String> topicSet = new HashSet<String>(1);
        String remoteAddress = null;
        int count = 0;
        while (consumerRecordIterator.hasNext()) {
            Object consumerRecord = consumerRecordIterator.next();
            if (!(consumerRecord instanceof ConsumerRecord)) continue;
            if (remoteAddress == null) {
                remoteAddress = ConsumerRecordsDesc.getRemoteAddress(consumerRecord);
            }
            String topic = ((ConsumerRecord)consumerRecord).topic();
            topicSet.add(topic);
            ++count;
        }
        if (count > 0) {
            return new ConsumerRecordsDesc(topicSet, remoteAddress, count);
        }
        return null;
    }

    private static String getRemoteAddress(Object remoteAddressFieldAccessor) {
        if (remoteAddressFieldAccessor instanceof RemoteAddressFieldAccessor) {
            return ((RemoteAddressFieldAccessor)remoteAddressFieldAccessor)._$PINPOINT$_getRemoteAddress();
        }
        return null;
    }
}

