/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.logback;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.logback.LogbackConfig;
import java.security.ProtectionDomain;
import java.util.Arrays;

public class LogbackPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        LogbackConfig config = new LogbackConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("LogbackPlugin config:{}", (Object)config);
        }
        if (!config.isLogbackLoggingTransactionInfo()) {
            this.logger.info("Logback plugin is not executed because logback transform enable config value is false.");
            return;
        }
        this.transformTemplate.transform("ch.qos.logback.classic.spi.LoggingEvent", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass mdcClass = instrumentor.getInstrumentClass(loader, "org.slf4j.MDC", null);
                if (mdcClass == null) {
                    LogbackPlugin.this.logger.warn("Can not modify. Because org.slf4j.MDC does not exist.");
                    return null;
                }
                if (!mdcClass.hasMethod("put", new String[]{"java.lang.String", "java.lang.String"})) {
                    LogbackPlugin.this.logger.warn("Can not modify. Because put method does not exist at org.slf4j.MDC class.");
                    return null;
                }
                if (!mdcClass.hasMethod("remove", new String[]{"java.lang.String"})) {
                    LogbackPlugin.this.logger.warn("Can not modify. Because remove method does not exist at org.slf4j.MDC class.");
                    return null;
                }
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.hasConstructor(new String[0])) {
                    LogbackPlugin.this.logger.warn("Can not modify. Because constructor to modify not exist at ch.qos.logback.classic.spi.LoggingEvent class.\nconstructor prototype : LoggingEvent();");
                    return null;
                }
                if (!target.hasConstructor(new String[]{"java.lang.String", "ch.qos.logback.classic.Logger", "ch.qos.logback.classic.Level", "java.lang.String", "java.lang.Throwable", "java.lang.Object[]"})) {
                    LogbackPlugin.this.logger.warn("Can not modify. Because constructor to modify not exist at ch.qos.logback.classic.spi.LoggingEvent class.\nconstructor prototype : LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray);");
                    return null;
                }
                String interceptorClassName = "com.navercorp.pinpoint.plugin.logback.interceptor.LoggingEventOfLogbackInterceptor";
                this.addInterceptor(target, new String[0], "com.navercorp.pinpoint.plugin.logback.interceptor.LoggingEventOfLogbackInterceptor");
                this.addInterceptor(target, new String[]{"java.lang.String", "ch.qos.logback.classic.Logger", "ch.qos.logback.classic.Level", "java.lang.String", "java.lang.Throwable", "java.lang.Object[]"}, "com.navercorp.pinpoint.plugin.logback.interceptor.LoggingEventOfLogbackInterceptor");
                return target.toBytecode();
            }

            private void addInterceptor(InstrumentClass target, String[] parameterTypes, String interceptorClassName) throws InstrumentException {
                InstrumentMethod constructor = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])parameterTypes);
                if (constructor == null) {
                    throw new NotFoundInstrumentException("Cannot find constructor with parameter types: " + Arrays.toString(parameterTypes));
                }
                constructor.addInterceptor(interceptorClassName);
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

