/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.tomcat;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.plugin.tomcat.TomcatConfig;
import com.navercorp.pinpoint.plugin.tomcat.TomcatDetector;
import java.security.ProtectionDomain;

public class TomcatPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        TomcatConfig config = new TomcatConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("TomcatPlugin disabled");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("TomcatPlugin config:{}", (Object)config);
        }
        TomcatDetector tomcatDetector = new TomcatDetector(config.getBootstrapMains());
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{tomcatDetector});
        if (this.shouldAddTransformers(config)) {
            this.logger.info("Adding Tomcat transformers");
            this.addTransformers(config);
        } else {
            this.logger.info("Not adding Tomcat transfomers");
        }
    }

    private boolean shouldAddTransformers(TomcatConfig config) {
        if (!config.isConditionalTransformEnable()) {
            return true;
        }
        ConditionProvider conditionProvider = ConditionProvider.DEFAULT_CONDITION_PROVIDER;
        boolean isTomcatApplication = conditionProvider.checkMainClass(config.getBootstrapMains());
        boolean isSpringBootApplication = conditionProvider.checkMainClass(config.getSpringBootBootstrapMains());
        return isTomcatApplication || isSpringBootApplication;
    }

    private void addTransformers(TomcatConfig config) {
        this.addStandardService();
        this.addTomcatConnector();
        this.addWebappLoader();
        this.addRequest();
        this.addRequestFacade(config);
        this.addStandardHostValve();
    }

    private void addStandardService() {
        this.transformTemplate.transform("org.apache.catalina.core.StandardService", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod startInternalEditor;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startEditor = target.getDeclaredMethod("start", new String[0]);
                if (startEditor != null) {
                    startEditor.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.StandardServiceStartInterceptor");
                }
                if ((startInternalEditor = target.getDeclaredMethod("startInternal", new String[0])) != null) {
                    startInternalEditor.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.StandardServiceStartInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addTomcatConnector() {
        this.transformTemplate.transform("org.apache.catalina.connector.Connector", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod initInternalEditor;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod initializeEditor = target.getDeclaredMethod("initialize", new String[0]);
                if (initializeEditor != null) {
                    initializeEditor.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.ConnectorInitializeInterceptor");
                }
                if ((initInternalEditor = target.getDeclaredMethod("initInternal", new String[0])) != null) {
                    initInternalEditor.addScopedInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.ConnectorInitializeInterceptor", "TomcatServletAsyncScope");
                }
                return target.toBytecode();
            }
        });
    }

    private void addWebappLoader() {
        this.transformTemplate.transform("org.apache.catalina.loader.WebappLoader", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startMethod = null;
                if (target.hasDeclaredMethod("start", new String[0])) {
                    startMethod = target.getDeclaredMethod("start", new String[0]);
                } else if (target.hasDeclaredMethod("startInternal", new String[0])) {
                    startMethod = target.getDeclaredMethod("startInternal", new String[0]);
                }
                if (startMethod != null) {
                    startMethod.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.WebappLoaderStartInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequest() {
        this.transformTemplate.transform("org.apache.catalina.connector.Request", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"});
                if (startAsyncMethodEditor != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.RequestStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequestFacade(final TomcatConfig config) {
        this.transformTemplate.transform("org.apache.catalina.connector.RequestFacade", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (config.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.tomcat.aspect.RequestFacadeAspect");
                }
                return target.toBytecode();
            }
        });
    }

    private void addStandardHostValve() {
        this.transformTemplate.transform("org.apache.catalina.core.StandardHostValve", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod method = target.getDeclaredMethod("invoke", new String[]{"org.apache.catalina.connector.Request", "org.apache.catalina.connector.Response"});
                if (method != null) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.tomcat.interceptor.StandardHostValveInvokeInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

