/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans.interceptor;

import java.util.LinkedHashMap;
import java.util.Map;

public class Cache {
    private static final int SHARD_SIZE_LIMIT = 64;
    private static final int SHARD_NUM = 13;
    private final Shard[] shards = new Shard[13];

    public Cache() {
        for (int i = 0; i < 13; ++i) {
            this.shards[i] = new Shard();
        }
    }

    public void clear() {
        for (int i = 0; i < 13; ++i) {
            this.shards[i].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String className) {
        Shard shard;
        Shard shard2 = shard = this.getShard(className);
        synchronized (shard2) {
            return shard.containsKey(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String className) {
        Shard shard;
        Shard shard2 = shard = this.getShard(className);
        synchronized (shard2) {
            shard.put(className, Boolean.TRUE);
        }
    }

    private Shard getShard(String className) {
        int idx = className.hashCode() % 13;
        if (idx < 0) {
            idx += 13;
        }
        return this.shards[idx];
    }

    private static final class Shard
    extends LinkedHashMap<String, Boolean> {
        private Shard() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 64;
        }
    }
}

