/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.autolog;

import com.tapm.starter.flow.FlowEngine;
import com.tapm.starter.flow.FlowItem;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.FlowItemNotExistException;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.exception.ProcessorExistedException;
import com.tapm.starter.flow.exception.ProcessorNotFoundException;
import com.tapm.starter.logger.autolog.UpdateLockTimeJob;
import com.tapm.starter.logger.autolog.processor.AutoDirScanProcessor;
import com.tapm.starter.logger.autolog.processor.CheckLockTimeUpdaterProcessor;
import com.tapm.starter.logger.autolog.processor.CreateNewLogDirProcessor;
import com.tapm.starter.logger.autolog.processor.LockFileCreatorProcessor;
import com.tapm.starter.logger.autolog.processor.LockFileDeleteProcessor;
import com.tapm.starter.logger.autolog.processor.LockFileExistCheckerProcessor;
import com.tapm.starter.util.DockerData;
import com.tapm.starter.util.StarterUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AutoLoggingGenerator {
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public static File getAutoLoggingFileDirFile(File baseDir, int dirSize) throws ProcessorExistedException, IOException, ProcessorNotFoundException, FlowItemNotExistException, ProcessException {
        ProcessContext processContext = null;
        processContext = AutoLoggingGenerator.generateContext(baseDir, dirSize);
        FlowEngine flowEngine = AutoLoggingGenerator.prepareFlowEngine();
        FlowItem autoDirScanFlow = FlowItem.newBuilderForProcessorName("autoDirScan").build();
        FlowItem lockFileCreator = FlowItem.newBuilderForProcessorName("lockFileCreator").on("reScan").toProcessor(autoDirScanFlow).on("next").toProcessor("lockFileDeleter").build();
        FlowItem checkLockTimeUpdater = FlowItem.newBuilderForProcessorName("checkLockTimeUpdater").on("reScan").toProcessor(autoDirScanFlow).on("next").toProcessor(lockFileCreator).build();
        FlowItem lockFileExistChecker = FlowItem.newBuilderForProcessorName("lockFileExistChecker").on("next").toProcessor(lockFileCreator).on("reScan").toProcessor(autoDirScanFlow).on("checkLockTimeUpdater").toProcessor(checkLockTimeUpdater).build();
        FlowItem createNewLogDirFlow = FlowItem.newBuilderForProcessorName("createNewLogDir").on("next").toProcessor(autoDirScanFlow).build();
        createNewLogDirFlow.putNext("reCreate", createNewLogDirFlow);
        autoDirScanFlow.putNext("next", lockFileExistChecker);
        autoDirScanFlow.putNext("createDir", createNewLogDirFlow);
        flowEngine.start(autoDirScanFlow, processContext);
        File file = (File)processContext.get("lockFile");
        String processId = (String)processContext.get("processId");
        String containerId = (String)processContext.get("containerId");
        UpdateLockTimeJob updateLockTimeJob = new UpdateLockTimeJob(processId, file, containerId);
        executorService.scheduleAtFixedRate(updateLockTimeJob, 5L, 5L, TimeUnit.SECONDS);
        return (File)processContext.get("processDir");
    }

    public static FlowEngine prepareFlowEngine() throws ProcessorExistedException {
        FlowEngine flowEngine = new FlowEngine();
        flowEngine.registProcessor("autoDirScan", new AutoDirScanProcessor());
        flowEngine.registProcessor("createNewLogDir", new CreateNewLogDirProcessor());
        flowEngine.registProcessor("lockFileExistChecker", new LockFileExistCheckerProcessor());
        flowEngine.registProcessor("lockFileCreator", new LockFileCreatorProcessor());
        flowEngine.registProcessor("checkLockTimeUpdater", new CheckLockTimeUpdaterProcessor());
        flowEngine.registProcessor("lockFileDeleter", new LockFileDeleteProcessor());
        return flowEngine;
    }

    protected static ProcessContext generateContext(File baseDir, int dirSize) throws IOException {
        ProcessContext processContext = new ProcessContext();
        processContext.put("baseWorkDir", baseDir);
        processContext.put("processId", StarterUtil.getPid());
        processContext.put("index", 1);
        processContext.put("dirSize", dirSize);
        String dockerContainerId = DockerData.getDockerContainerId();
        if (dockerContainerId != null) {
            processContext.put("containerId", dockerContainerId);
        }
        return processContext;
    }
}

