/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.appender;

import com.tapm.starter.AgentStarter;
import com.tapm.starter.logger.appender.AllAppender;
import com.tapm.starter.logger.appender.ConsoleAppender;
import com.tapm.starter.logger.appender.FileAppender;
import com.tapm.starter.logger.appender.IAppender;
import com.tapm.starter.util.DockerData;
import com.tapm.starter.util.StarterUtil;
import java.io.File;

public class Appender {
    private static final AllAppender allAppender = new AllAppender();

    private static String getLoggerFileName() {
        if (AgentStarter.isOneAgent || AgentStarter.isAutoClear) {
            StringBuilder loggerFileName = new StringBuilder("java-starter");
            String dockerContainerId = DockerData.getDockerContainerId();
            if (dockerContainerId != null) {
                loggerFileName.append("-").append(dockerContainerId);
            }
            loggerFileName.append("-").append(StarterUtil.getPid()).append(".log");
            return loggerFileName.toString();
        }
        return "tapm_starter.log";
    }

    public static IAppender getAppender() {
        return allAppender;
    }

    static {
        String stdout = System.getProperty("tapm.log.stdout");
        if (stdout != null && stdout.equalsIgnoreCase("true")) {
            allAppender.addAppender(new ConsoleAppender());
        }
        int defaultScroll = 10;
        String scroll = System.getProperty("tapm.starter.log_max_scroll");
        if (scroll != null && scroll.length() > 0) {
            try {
                defaultScroll = Integer.parseInt(scroll);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (AgentStarter.finalLogDir != null) {
            final FileAppender fileAppender = new FileAppender(new File(AgentStarter.finalLogDir, Appender.getLoggerFileName()), defaultScroll);
            try {
                fileAppender.open();
                allAppender.addAppender(fileAppender);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        fileAppender.close();
                    }
                });
            }
            catch (Exception e) {
                System.err.print("Failed to open Tapm starter log file " + e.getMessage());
            }
        } else {
            System.err.print("Failed to open Tapm starter log file, agent directory is null");
        }
    }
}

