/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.processors.UpdateResult;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class UpdateCheckProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("UpdateCheckProcessor");
    public static final String FLOW_NO_UPDATE = "no-update";
    public static final String FLOW_NO_UPDATE_AND_CLEAR = "no-update-clear";
    public static final String CONTEXT_UPDATE_INFO_FILE = "update_info_file";
    public static final String CONTEXT_UPDATE_FILE = "update_file";
    public static final String CONTEXT_UPDATE_MD5 = "update_md5";
    public static final String CONTEXT_UPDATE_VERSION = "update_version";
    public static final String CONTEXT_UPDATE_INSTANCEID = "update_instanceid";
    public static final String CONTEXT_UPDATE_EVENTID = "update_eventid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String process(ProcessContext context) throws ProcessException {
        File agentUpdateDir = (File)context.get("Agent-Update-Directory");
        String agentVersion = (String)context.get("Agent-Version");
        List runningPids = (List)context.get("context_running_pids");
        BufferedReader br = null;
        try {
            if (runningPids != null && !runningPids.isEmpty()) {
                this.logger.info("There is at least one process using the agent, abandon upgrade checks, and start agent directly");
                String string = FLOW_NO_UPDATE;
                return string;
            }
            if (!agentUpdateDir.exists()) {
                this.logger.info("No directory for updates");
                String string = FLOW_NO_UPDATE;
                return string;
            }
            File agentUpdateInfoFile = new File(agentUpdateDir, "tapm.update");
            if (!agentUpdateInfoFile.exists()) {
                this.logger.info("No file for tapm.update");
                String string = FLOW_NO_UPDATE;
                return string;
            }
            this.logger.info("Upgrade information file detected");
            context.put(CONTEXT_UPDATE_INFO_FILE, agentUpdateInfoFile);
            br = new BufferedReader(new FileReader(agentUpdateInfoFile));
            String instanceId = br.readLine();
            String newVersion = br.readLine();
            String md5 = br.readLine();
            String eventId = br.readLine();
            if (newVersion == null || "".equals(newVersion.trim()) || md5 == null || "".equals(md5.trim())) {
                this.logger.warn("The format of the file tapm.update does not meet expectations");
                String string = FLOW_NO_UPDATE_AND_CLEAR;
                return string;
            }
            context.put(CONTEXT_UPDATE_EVENTID, eventId);
            context.put(CONTEXT_UPDATE_INSTANCEID, instanceId);
            if (newVersion.equals(agentVersion)) {
                this.logger.warn("The two agent have the same version({}) and do not need to be upgraded", agentVersion);
                context.put("context_update_result", UpdateResult.failed(1, "same version " + newVersion));
                String string = FLOW_NO_UPDATE_AND_CLEAR;
                return string;
            }
            String newAgentFileName = "tapm-agent-java-" + newVersion + ".zip";
            File newAgentFile = new File(agentUpdateDir, newAgentFileName);
            if (!newAgentFile.exists()) {
                this.logger.warn("No agent upgrade package({}) , no upgrade", newAgentFileName);
                String string = FLOW_NO_UPDATE_AND_CLEAR;
                return string;
            }
            context.put(CONTEXT_UPDATE_FILE, newAgentFile);
            context.put(CONTEXT_UPDATE_MD5, md5);
            context.put(CONTEXT_UPDATE_VERSION, newVersion);
            this.logger.info("New version({}) detected, ready for update", newVersion);
            String string = "next";
            return string;
        }
        catch (Exception e) {
            context.put("context_update_result", UpdateResult.failed(2, "Error checking update process, " + e.getMessage()));
            this.logger.error("Failed to check Tapm agent update", e);
            String string = FLOW_NO_UPDATE;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

