/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.File;
import java.util.ArrayList;

public class PidLockCheckProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("PidLockCheckProcessor");
    public static final String CONTEXT_RUNNING_PIDS = "context_running_pids";

    @Override
    public String process(ProcessContext context) throws ProcessException {
        try {
            File agentUpdateDir = (File)context.get("Agent-Update-Directory");
            File agentUpdateLockDir = (File)context.get("Agent-Update-Lock-Directory");
            if (!agentUpdateDir.exists()) {
                this.logger.info("No directory for updates");
                return "next";
            }
            if (!agentUpdateLockDir.exists()) {
                this.logger.info("No directory for update lock");
                return "next";
            }
            ArrayList<String> pids = new ArrayList<String>();
            context.put(CONTEXT_RUNNING_PIDS, pids);
            File[] pidLockFiles = agentUpdateLockDir.listFiles();
            if (pidLockFiles != null && pidLockFiles.length > 0) {
                for (File pidLockFile : pidLockFiles) {
                    if (!pidLockFile.isFile()) continue;
                    String name = pidLockFile.getName();
                    String pid = name.split("\\.")[0];
                    try {
                        if (pidLockFile.delete()) continue;
                        this.logger.info("The process {} also uses this agent", pid);
                        pids.add(pid);
                    }
                    catch (Exception e) {
                        this.logger.warn("Error in deleting lock file " + pid + ".lock, ", e);
                        pids.add(pid);
                    }
                }
            }
            if (pids.isEmpty()) {
                this.logger.info("No other process using this agent");
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred while checking the PID lock", e);
        }
        return "next";
    }
}

