/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ProcessContext {
    private static final int DEFAULT_PRIORITY = 0;
    private HashMap<String, PriorityValue> context = new HashMap();

    public boolean put(String key, Object value) {
        return this.compareAndSet(key, new PriorityValue(0, value));
    }

    public boolean put(String key, Object value, int priority) {
        return this.compareAndSet(key, new PriorityValue(priority, value));
    }

    public void putAll(Map<String, Object> sec) {
        Set<Map.Entry<String, Object>> entrys = sec.entrySet();
        for (Map.Entry<String, Object> entry : entrys) {
            this.compareAndSet(entry.getKey(), new PriorityValue(0, entry.getValue()));
        }
    }

    public Object get(String key) {
        PriorityValue v = this.context.get(key);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public Object remove(String key) {
        PriorityValue v = this.context.remove(key);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public void clear() {
        this.context.clear();
    }

    private boolean compareAndSet(String key, PriorityValue value) {
        PriorityValue v = this.context.get(key);
        if (v == null) {
            this.context.put(key, value);
            return true;
        }
        if (v.getPriority() <= value.getPriority()) {
            this.context.put(key, value);
            return true;
        }
        return false;
    }

    private static class PriorityValue {
        private int priority;
        private Object value;

        public PriorityValue(int priority, Object value) {
            this.priority = priority;
            this.value = value;
        }

        public int getPriority() {
            return this.priority;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

