/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.user;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class UserPluginConfig {
    private final List<String> includeList;
    private final List<String> mqClientHandlerMethods;

    public UserPluginConfig(ProfilerConfig src) {
        this.includeList = this.split(src.readString("profiler.entrypoint", ""));
        this.mqClientHandlerMethods = src.readList("profiler.message.queue.client.handler.methods");
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getMqClientHandlerMethods() {
        return this.mqClientHandlerMethods;
    }

    private List<String> split(String values) {
        if (StringUtils.isEmpty((String)values)) {
            return Collections.emptyList();
        }
        return StringUtils.tokenizeToStringList((String)values, (String)",");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{includeList=");
        builder.append(this.includeList);
        builder.append("}");
        return builder.toString();
    }
}

