/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.context.thrift.BypassMessageConverter;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutor;
import com.navercorp.pinpoint.profiler.sender.DefaultAsyncQueueingExecutorListener;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.profiler.sender.RequestMessage;
import com.navercorp.pinpoint.profiler.sender.RequestMessageFactory;
import com.navercorp.pinpoint.profiler.sender.RetryMessage;
import com.navercorp.pinpoint.profiler.sender.RetryQueue;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import com.navercorp.pinpoint.rpc.util.ClientFactoryUtils;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.thrift.TBase;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpDataSender
implements EnhancedDataSender<Object> {
    private final Logger logger;
    private final PinpointClient client;
    private final Timer timer;
    private final AtomicBoolean fireState = new AtomicBoolean(false);
    private final WriteFailFutureListener writeFailFutureListener;
    private final MessageSerializer<byte[]> messageSerializer;
    private final RetryQueue retryQueue = new RetryQueue();
    protected final AsyncQueueingExecutor<Object> executor;

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory) {
        this(name, ClientFactoryUtils.newPinpointClientProvider((String)host, (int)port, (PinpointClientFactory)clientFactory), TcpDataSender.newDefaultMessageSerializer());
    }

    private static ThriftMessageSerializer newDefaultMessageSerializer() {
        BypassMessageConverter messageConverter = new BypassMessageConverter();
        return new ThriftMessageSerializer(messageConverter);
    }

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory, MessageSerializer<byte[]> messageSerializer) {
        this(name, ClientFactoryUtils.newPinpointClientProvider((String)host, (int)port, (PinpointClientFactory)clientFactory), messageSerializer);
    }

    private TcpDataSender(String name, ClientFactoryUtils.PinpointClientProvider clientProvider, MessageSerializer<byte[]> messageSerializer) {
        this.logger = this.newLogger(name);
        Assert.requireNonNull((Object)clientProvider, (String)"clientProvider must not be null");
        this.client = clientProvider.get();
        this.messageSerializer = (MessageSerializer)Assert.requireNonNull(messageSerializer, (String)"messageSerializer must not be null");
        this.timer = this.createTimer(name);
        this.writeFailFutureListener = new WriteFailFutureListener(this.logger, "io write fail.", "host", -1);
        String executorName = this.getExecutorName(name);
        this.executor = this.createAsyncQueueingExecutor(5120, executorName);
    }

    private AsyncQueueingExecutor<Object> createAsyncQueueingExecutor(int queueSize, String executorName) {
        DefaultAsyncQueueingExecutorListener listener = new DefaultAsyncQueueingExecutorListener(){

            @Override
            public void execute(Object message) {
                TcpDataSender.this.sendPacket(message);
            }
        };
        AsyncQueueingExecutor<Object> executor = new AsyncQueueingExecutor<Object>(queueSize, executorName, listener);
        return executor;
    }

    private Logger newLogger(String name) {
        if (name == null) {
            return LoggerFactory.getLogger(this.getClass());
        }
        return LoggerFactory.getLogger((String)(this.getClass().getName() + "@" + name));
    }

    private String getExecutorName(String name) {
        if (name == null) {
            return "Pinpoint-TcpDataSender-Executor";
        }
        return String.format("Pinpoint-TcpDataSender(%s)-Executor", name);
    }

    private Timer createTimer(String name) {
        String timerName = this.getTimerName(name);
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer((String)timerName, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (int)512);
        timer.start();
        return timer;
    }

    private String getTimerName(String name) {
        if (name == null) {
            return "Pinpoint-TcpDataSender-Timer";
        }
        return String.format("Pinpoint-TcpDataSender(%s)-Timer", name);
    }

    @Override
    public boolean send(Object data) {
        return this.executor.execute(data);
    }

    @Override
    public boolean request(Object data) {
        return this.request(data, 3);
    }

    @Override
    public boolean request(Object data, int retryCount) {
        RequestMessage<Object> message = RequestMessageFactory.request(data, retryCount);
        return this.executor.execute(message);
    }

    @Override
    public boolean request(Object data, FutureListener<ResponseMessage> listener) {
        RequestMessage<Object> message = RequestMessageFactory.request(data, listener);
        return this.executor.execute(message);
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public boolean addReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return this.client.addPinpointClientReconnectEventListener(eventListener);
    }

    @Override
    public boolean removeReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return this.client.removePinpointClientReconnectEventListener(eventListener);
    }

    @Override
    public void stop() {
        this.executor.stop();
        Set stop = this.timer.stop();
        if (!stop.isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void sendPacket(Object message) {
        try {
            RequestMessage requestMessage;
            if (message instanceof RequestMessage && this.doRequest(requestMessage = (RequestMessage)message)) {
                return;
            }
            byte[] copy = this.messageSerializer.serializer(message);
            if (copy == null) {
                this.logger.error("sendPacket fail. invalid dto type:{}", message.getClass());
                return;
            }
            this.doSend(copy);
        }
        catch (Exception e) {
            this.logger.warn("tcp send fail. Caused:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean doRequest(RequestMessage<?> requestMessage) {
        Object message = requestMessage.getMessage();
        byte[] copy = this.messageSerializer.serializer(message);
        if (copy == null) {
            return false;
        }
        FutureListener futureListener = requestMessage.getFutureListener();
        if (futureListener != null) {
            this.doRequest(copy, futureListener);
        } else {
            int retryCount = requestMessage.getRetryCount();
            this.doRequest(copy, retryCount, message);
        }
        return true;
    }

    protected void doSend(byte[] copy) {
        Future write = this.client.sendAsync(copy);
        write.setListener((FutureListener)this.writeFailFutureListener);
    }

    private void doRequest(final byte[] requestPacket, final int maxRetryCount, final Object targetClass) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)future.getResult();
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase response = TcpDataSender.this.deserialize(deserializer, responseMessage.getMessage());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", targetClass, (Object)result.getMessage());
                            RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid response:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", new Object[]{targetClass, future.getCause().getMessage(), future.getCause()});
                    RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(requestPacket, (FutureListener)futureListener);
    }

    private void doRequest(final RetryMessage retryMessage) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    ResponseMessage responseMessage;
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase response = TcpDataSender.this.deserialize(deserializer, (responseMessage = (ResponseMessage)future.getResult()).getMessage());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{}, Caused:{}", (Object)retryMessage, (Object)result.getMessage());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid response:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{}, caused:{}", new Object[]{retryMessage, future.getCause().getMessage(), future.getCause()});
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(retryMessage.getBytes(), (FutureListener)futureListener);
    }

    private TBase<?, ?> deserialize(HeaderTBaseDeserializer deserializer, byte[] message) {
        Message deserialize = SerializationUtils.deserialize((byte[])message, (HeaderTBaseDeserializer)deserializer, null);
        if (deserialize == null) {
            return null;
        }
        return (TBase)deserialize.getData();
    }

    private void retryRequest(RetryMessage retryMessage) {
        this.retryQueue.add(retryMessage);
        if (this.fireTimeout()) {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    while (true) {
                        RetryMessage retryMessage;
                        if ((retryMessage = TcpDataSender.this.retryQueue.get()) == null) {
                            TcpDataSender.this.fireComplete();
                            return;
                        }
                        int fail = retryMessage.fail();
                        TcpDataSender.this.doRequest(retryMessage);
                    }
                }
            }, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    private void doRequest(byte[] requestPacket, FutureListener futureListener) {
        Future response = this.client.request(requestPacket);
        response.setListener(futureListener);
    }

    private boolean fireTimeout() {
        return this.fireState.compareAndSet(false, true);
    }

    private void fireComplete() {
        this.logger.debug("fireComplete");
        this.fireState.compareAndSet(true, false);
    }

    static {
        ChannelBuffers.buffer((int)2);
    }
}

