/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.bootstrap.plugin.ObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.AutoBindingObjectFactory;
import com.navercorp.pinpoint.profiler.objectfactory.JudgingParameterResolver;
import com.navercorp.pinpoint.profiler.objectfactory.Option;
import com.navercorp.pinpoint.profiler.util.TypeUtils;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedValueProvider
implements JudgingParameterResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AutoBindingObjectFactory objectFactory;
    private final Object[] values;
    private int index = 0;

    public OrderedValueProvider(AutoBindingObjectFactory objectFactory, Object[] values) {
        this.objectFactory = objectFactory;
        this.values = values;
    }

    @Override
    public void prepare() {
        this.index = -1;
        this.prepareNextCandidate();
    }

    @Override
    public Option get(int index, Class<?> type, Annotation[] annotations) {
        if (this.index >= this.values.length) {
            return Option.empty();
        }
        Object value = this.values[this.index];
        if (type.isPrimitive()) {
            if (value == null) {
                return Option.empty();
            }
            if (TypeUtils.getWrapperOf(type) == value.getClass()) {
                this.prepareNextCandidate();
                return Option.withValue(value);
            }
        } else {
            if (type.isInstance(value)) {
                this.prepareNextCandidate();
                return Option.withValue(value);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("argument miss match index:{}, type:{} value:{} typeCl:{}, valueCl:{}", new Object[]{this.index, type, value, type.getClassLoader(), this.getClassLoader(value)});
            }
        }
        return Option.empty();
    }

    private ClassLoader getClassLoader(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getClassLoader();
    }

    private void prepareNextCandidate() {
        ++this.index;
        if (this.index >= this.values.length) {
            return;
        }
        Object val = this.values[this.index];
        if (val instanceof ObjectFactory) {
            this.values[this.index] = val = this.objectFactory.createInstance((ObjectFactory)val, new ArgumentProvider[0]);
        }
    }

    @Override
    public boolean isAcceptable() {
        return this.index == this.values.length;
    }
}

