/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector;

import com.google.inject.Inject;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.thrift.dto.TActiveTrace;
import com.navercorp.pinpoint.thrift.dto.TAgentStat;
import com.navercorp.pinpoint.thrift.dto.TCpuLoad;
import com.navercorp.pinpoint.thrift.dto.TDataSourceList;
import com.navercorp.pinpoint.thrift.dto.TDeadlock;
import com.navercorp.pinpoint.thrift.dto.TDirectBuffer;
import com.navercorp.pinpoint.thrift.dto.TFileDescriptor;
import com.navercorp.pinpoint.thrift.dto.TJvmGc;
import com.navercorp.pinpoint.thrift.dto.TResponseTime;
import com.navercorp.pinpoint.thrift.dto.TTransaction;

public class AgentStatCollector
implements AgentStatMetricCollector<TAgentStat> {
    private final String agentId;
    private final long agentStartTimestamp;
    private final AgentStatMetricCollector<TJvmGc> jvmGcMetricCollector;
    private final AgentStatMetricCollector<TCpuLoad> cpuLoadMetricCollector;
    private final AgentStatMetricCollector<TTransaction> transactionMetricCollector;
    private final AgentStatMetricCollector<TActiveTrace> activeTraceMetricCollector;
    private final AgentStatMetricCollector<TDataSourceList> dataSourceMetricCollector;
    private final AgentStatMetricCollector<TResponseTime> responseTimeMetricCollector;
    private final AgentStatMetricCollector<TDeadlock> deadlockMetricCollector;
    private final AgentStatMetricCollector<TFileDescriptor> fileDescriptorMetricCollector;
    private final AgentStatMetricCollector<TDirectBuffer> bufferMetricCollector;

    @Inject
    public AgentStatCollector(@AgentId String agentId, @AgentStartTime long agentStartTimestamp, AgentStatMetricCollector<TJvmGc> jvmGcMetricCollector, AgentStatMetricCollector<TCpuLoad> cpuLoadMetricCollector, AgentStatMetricCollector<TTransaction> transactionMetricCollector, AgentStatMetricCollector<TActiveTrace> activeTraceMetricCollector, AgentStatMetricCollector<TDataSourceList> dataSourceMetricCollector, AgentStatMetricCollector<TResponseTime> responseTimeMetricCollector, AgentStatMetricCollector<TDeadlock> deadlockMetricCollector, AgentStatMetricCollector<TFileDescriptor> fileDescriptorMetricCollector, AgentStatMetricCollector<TDirectBuffer> bufferMetricCollector) {
        this.agentId = (String)Assert.requireNonNull((Object)agentId, (String)"agentId must not be null");
        this.agentStartTimestamp = agentStartTimestamp;
        this.jvmGcMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(jvmGcMetricCollector, (String)"jvmGcMetricCollector must not be null");
        this.cpuLoadMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(cpuLoadMetricCollector, (String)"cpuLoadMetricCollector must not be null");
        this.transactionMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(transactionMetricCollector, (String)"transactionMetricCollector must not be null");
        this.activeTraceMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(activeTraceMetricCollector, (String)"activeTraceMetricCollector must not be null");
        this.dataSourceMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(dataSourceMetricCollector, (String)"dataSourceMetricCollector must not be null");
        this.responseTimeMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(responseTimeMetricCollector, (String)"responseTimeMetricCollector must not be null");
        this.deadlockMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(deadlockMetricCollector, (String)"deadlockMetricCollector must not be null");
        this.fileDescriptorMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(fileDescriptorMetricCollector, (String)"fileDescriptorMetricCollector must not be null");
        this.bufferMetricCollector = (AgentStatMetricCollector)Assert.requireNonNull(bufferMetricCollector, (String)"bufferMetricCollector must not be null");
    }

    @Override
    public TAgentStat collect() {
        TAgentStat agentStat = new TAgentStat();
        agentStat.setAgentId(this.agentId);
        agentStat.setStartTimestamp(this.agentStartTimestamp);
        agentStat.setGc(this.jvmGcMetricCollector.collect());
        agentStat.setCpuLoad(this.cpuLoadMetricCollector.collect());
        agentStat.setTransaction(this.transactionMetricCollector.collect());
        agentStat.setActiveTrace(this.activeTraceMetricCollector.collect());
        agentStat.setDataSourceList(this.dataSourceMetricCollector.collect());
        agentStat.setResponseTime(this.responseTimeMetricCollector.collect());
        agentStat.setDeadlock(this.deadlockMetricCollector.collect());
        agentStat.setFileDescriptor(this.fileDescriptorMetricCollector.collect());
        agentStat.setDirectBuffer(this.bufferMetricCollector.collect());
        return agentStat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgentStatCollector{");
        sb.append("agentId='").append(this.agentId).append('\'');
        sb.append(", agentStartTimestamp=").append(this.agentStartTimestamp);
        sb.append(", jvmGcMetricCollector=").append(this.jvmGcMetricCollector);
        sb.append(", cpuLoadMetricCollector=").append(this.cpuLoadMetricCollector);
        sb.append(", transactionMetricCollector=").append(this.transactionMetricCollector);
        sb.append(", activeTraceMetricCollector=").append(this.activeTraceMetricCollector);
        sb.append(", dataSourceMetricCollector=").append(this.dataSourceMetricCollector);
        sb.append(", responseTimeMetricCollector=").append(this.responseTimeMetricCollector);
        sb.append(", deadlockMetricCollector=").append(this.deadlockMetricCollector);
        sb.append(", fileDescriptorMetricCollector=").append(this.fileDescriptorMetricCollector);
        sb.append(", bufferMetricCollector=").append(this.bufferMetricCollector);
        sb.append('}');
        return sb.toString();
    }
}

