/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.profiler.metadata.CachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.DefaultCachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlMetaDataService
implements SqlMetaDataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final CachingSqlNormalizer cachingSqlNormalizer;
    private final EnhancedDataSender<Object> enhancedDataSender;

    @Inject
    public DefaultSqlMetaDataService(ProfilerConfig profilerConfig, EnhancedDataSender<Object> enhancedDataSender) {
        this(enhancedDataSender, profilerConfig.getJdbcSqlCacheSize());
    }

    public DefaultSqlMetaDataService(EnhancedDataSender<Object> enhancedDataSender, int jdbcSqlCacheSize) {
        if (enhancedDataSender == null) {
            throw new NullPointerException("enhancedDataSender must not be null");
        }
        this.enhancedDataSender = enhancedDataSender;
        this.cachingSqlNormalizer = new DefaultCachingSqlNormalizer(jdbcSqlCacheSize);
    }

    @Override
    public ParsingResult parseSql(String sql) {
        return this.cachingSqlNormalizer.wrapSql(sql);
    }

    @Override
    public boolean cacheSql(ParsingResult parsingResult) {
        if (parsingResult == null) {
            return false;
        }
        boolean isNewValue = this.cachingSqlNormalizer.normalizedSql(parsingResult);
        if (isNewValue) {
            if (this.isDebug) {
                this.logger.debug("NewSQLParsingResult:{}", (Object)parsingResult);
            }
            SqlMetaData sqlMetaData = new SqlMetaData(parsingResult.getId(), parsingResult.getSql());
            this.enhancedDataSender.request(sqlMetaData);
        }
        return isNewValue;
    }
}

