/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.storage.BufferedStorage;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.sender.DataSender;

public class BufferedStorageFactory
implements StorageFactory {
    private final DataSender dataSender;
    private final int ioBufferingBufferSize;

    public BufferedStorageFactory(int ioBufferingBufferSize, DataSender dataSender) {
        this.dataSender = (DataSender)Assert.requireNonNull((Object)dataSender, (String)"dataSender must not be null");
        this.ioBufferingBufferSize = ioBufferingBufferSize;
    }

    @Override
    public Storage createStorage(TraceRoot traceRoot) {
        BufferedStorage storage = new BufferedStorage(traceRoot, this.dataSender, this.ioBufferingBufferSize);
        return storage;
    }

    public String toString() {
        return "BufferedStorageFactory{dataSender=" + this.dataSender + ", ioBufferingBufferSize=" + this.ioBufferingBufferSize + '}';
    }
}

