/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.TraceDataFormatVersion;
import com.navercorp.pinpoint.profiler.context.compress.Context;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessor;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessorV1;
import com.navercorp.pinpoint.profiler.context.compress.SpanPostProcessorV2;

public class SpanPostProcessorProvider
implements Provider<SpanPostProcessor<Context>> {
    private final TraceDataFormatVersion version;

    @Inject
    public SpanPostProcessorProvider(TraceDataFormatVersion version) {
        this.version = (TraceDataFormatVersion)((Object)Assert.requireNonNull((Object)((Object)version), (String)"version must not be null"));
    }

    public SpanPostProcessor<Context> get() {
        if (this.version == TraceDataFormatVersion.V2) {
            return new SpanPostProcessorV2();
        }
        if (this.version == TraceDataFormatVersion.V1) {
            return new SpanPostProcessorV1();
        }
        throw new UnsupportedOperationException("unknown version :" + (Object)((Object)this.version));
    }
}

