/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.dubbo;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.dubbo.DubboConstants;
import java.util.Arrays;
import java.util.List;

public final class DubboProviderDetector
implements ApplicationTypeDetector {
    private static final String DEFAULT_BOOTSTRAP_MAIN = "com.alibaba.dubbo.container.Main";
    private static final String REQUIRED_CLASS = "com.alibaba.dubbo.rpc.proxy.AbstractProxyInvoker";
    private List<String> bootstrapMains;

    public DubboProviderDetector(List<String> bootstrapMains) {
        this.bootstrapMains = CollectionUtils.isEmpty(bootstrapMains) ? Arrays.asList(DEFAULT_BOOTSTRAP_MAIN) : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return DubboConstants.DUBBO_PROVIDER_SERVICE_TYPE;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains) || provider.checkForClass(REQUIRED_CLASS);
    }
}

