/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.model.PushOptions;
import com.mongodb.client.model.TextSearchOptions;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.mongo.Base64;
import com.navercorp.pinpoint.plugin.mongo.MongoConstants;
import com.navercorp.pinpoint.plugin.mongo.field.getter.ExtendedBsonListGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.FieldNameGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.OperatorGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.ValueGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.BsonValueGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FilterGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.FiltersGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.GeometryGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.InternalOperatorNameAccessor;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.IterableValuesGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.MaxDistanceGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.MinDistanceGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.OperatorNameGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.SearchGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.filters.TextSearchOptionsGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.updates.ListValuesGetter;
import com.navercorp.pinpoint.plugin.mongo.field.getter.updates.PushOptionsGetter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriter;

class WriteContext {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Writer writer = new StringWriter();
    private final BsonWriter bsonWriter = new JsonWriter(this.writer);
    private final List<String> jsonParameter;
    private final boolean traceBsonBindValue;
    private final boolean decimal128Enabled;
    private static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 8;
    static final String UNTRACED = "Unsupported-trace";

    public WriteContext(List<String> jsonParameterAppender, boolean decimal128Enabled, boolean traceBsonBindValue) {
        this.jsonParameter = (List)Assert.requireNonNull(jsonParameterAppender, (String)"jsonParameterAppender must not be null");
        this.decimal128Enabled = decimal128Enabled;
        this.traceBsonBindValue = traceBsonBindValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String parse(Object arg) {
        if (arg instanceof Bson) {
            this.writeValue(arg);
            return this.writer.toString();
        }
        if (!(arg instanceof List)) {
            this.logger.debug(UNTRACED);
            return UNTRACED;
        }
        if (((List)arg).get(0) instanceof Bson) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("bsons");
            this.writeValue(arg);
            this.bsonWriter.writeEndDocument();
            return this.writer.toString();
        }
        this.logger.debug(UNTRACED);
        return UNTRACED;
    }

    private void parseUpdatesObject(Object arg) {
        String argName = arg.getClass().getName();
        if (argName.equals("com.mongodb.client.model.Updates$SimpleUpdate")) {
            this.logger.debug("writing SimpleUpdate");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorGetter)arg)._$PINPOINT$_getOperator());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.writeValue(((ValueGetter)arg)._$PINPOINT$_getValue());
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        }
        if (argName.equals("com.mongodb.client.model.Updates$WithEachUpdate")) {
            this.logger.debug("writing WithEachUpdate");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorGetter)arg)._$PINPOINT$_getOperator());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeStartArray("$each");
            for (Object object : ((ListValuesGetter)arg)._$PINPOINT$_getValues()) {
                this.writeValue(object);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        }
        if (argName.equals("com.mongodb.client.model.Updates$PushUpdate")) {
            this.logger.debug("writing PushUpdate");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorGetter)arg)._$PINPOINT$_getOperator());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeStartArray("$each");
            for (Object object : ((ListValuesGetter)arg)._$PINPOINT$_getValues()) {
                this.writeValue(object);
            }
            this.bsonWriter.writeEndArray();
            PushOptions options = ((PushOptionsGetter)arg)._$PINPOINT$_getPushOptions();
            if (options.getPosition() != null) {
                this.bsonWriter.writeInt32("$position", options.getPosition().intValue());
            }
            if (options.getSlice() != null) {
                this.bsonWriter.writeInt32("$slice", options.getSlice().intValue());
            }
            if (options.getSort() != null) {
                this.bsonWriter.writeInt32("$sort", options.getSort().intValue());
            } else if (options.getSortDocument() != null) {
                this.bsonWriter.writeName("$sort");
                this.writeValue(options.getSortDocument());
            }
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        }
        if (argName.equals("com.mongodb.client.model.Updates$PullAllUpdate")) {
            this.logger.debug("writing PullAllUpdate");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$pullAll");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.bsonWriter.writeStartArray();
            for (Object object : ((ListValuesGetter)arg)._$PINPOINT$_getValues()) {
                this.writeValue(object);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        }
        if (argName.equals("com.mongodb.client.model.Updates$CompositeUpdate")) {
            this.logger.debug("writing CompositeUpdate");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeStartArray("$updates");
            for (Bson bson : ((ExtendedBsonListGetter)arg)._$PINPOINT$_getExtendedBsonList()) {
                this.writeValue(bson);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
        }
    }

    private void parseSortObject(Object arg) {
        String argName = arg.getClass().getName();
        if (argName.equals("com.mongodb.client.model.Sorts$CompoundSort")) {
            this.logger.debug("writing CompoundSort");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeStartArray("$sorts");
            for (Bson bson : ((ExtendedBsonListGetter)arg)._$PINPOINT$_getExtendedBsonList()) {
                this.writeValue(bson);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
        }
    }

    private void parseFilterObject(Object arg) {
        String argName = arg.getClass().getName();
        this.logger.debug("filter arg : " + arg.getClass().getName());
        if (argName.equals("com.mongodb.client.model.Filters$.GeometryOperatorFilter")) {
            this.logger.debug("writing GeometryOperatorFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorNameGetter)arg)._$PINPOINT$_getOperatorName());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$geometry");
            this.writeValue(((GeometryGetter)arg)._$PINPOINT$_getGeometry());
            if (((MaxDistanceGetter)arg)._$PINPOINT$_getMaxDistance() != null) {
                this.bsonWriter.writeDouble("$maxDistance", ((MaxDistanceGetter)arg)._$PINPOINT$_getMaxDistance().doubleValue());
            }
            if (((MinDistanceGetter)arg)._$PINPOINT$_getMinDistance() != null) {
                this.bsonWriter.writeDouble("$minDistance", ((MinDistanceGetter)arg)._$PINPOINT$_getMinDistance().doubleValue());
            }
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        }
        if (argName.equals("com.mongodb.client.model.Filters$OperatorFilter")) {
            this.logger.debug("writing OperatorFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorNameGetter)arg)._$PINPOINT$_getOperatorName());
            this.writeValue(((ValueGetter)arg)._$PINPOINT$_getValue());
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$IterableOperatorFilter")) {
            this.logger.debug("writing IterableOperatorFilter");
            if (arg instanceof FieldNameGetter) {
                this.bsonWriter.writeStartDocument();
                this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            }
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((OperatorNameGetter)arg)._$PINPOINT$_getOperatorName());
            this.writeValue(((IterableValuesGetter)arg)._$PINPOINT$_getValues());
            this.bsonWriter.writeEndDocument();
            if (arg instanceof FieldNameGetter) {
                this.bsonWriter.writeEndDocument();
            }
        } else if (argName.equals("com.mongodb.client.model.Filters$SimpleEncodingFilter")) {
            this.logger.debug("writing SimpleEncodingFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.writeValue(((ValueGetter)arg)._$PINPOINT$_getValue());
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$SimpleFilter")) {
            this.logger.debug("writing SimpleFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(((FieldNameGetter)arg)._$PINPOINT$_getFieldName());
            this.writeValue(((BsonValueGetter)arg)._$PINPOINT$_getValue());
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$AndFilter")) {
            this.logger.debug("writing AndFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$and");
            this.bsonWriter.writeStartArray();
            for (Bson bsonFilter : ((FiltersGetter)arg)._$PINPOINT$_getFilters()) {
                this.logger.debug("writing filters");
                this.writeValue(bsonFilter);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$NotFilter")) {
            this.logger.debug("writing NotFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$not");
            this.writeValue(((FilterGetter)arg)._$PINPOINT$_getFilter());
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$TextFilter")) {
            this.logger.debug("writing TextFilter");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$text");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$search");
            this.writeValue(((SearchGetter)arg)._$PINPOINT$_getSearch());
            TextSearchOptions textSearchOptions = ((TextSearchOptionsGetter)arg)._$PINPOINT$_getTextSearchOptions();
            if (textSearchOptions.getLanguage() != null) {
                this.bsonWriter.writeName("$language");
                this.writeValue(textSearchOptions.getLanguage());
            }
            if (textSearchOptions.getCaseSensitive() != null) {
                this.bsonWriter.writeName("$caseSensitive");
                this.writeValue(textSearchOptions.getCaseSensitive());
            }
            if (textSearchOptions.getDiacriticSensitive() != null) {
                this.bsonWriter.writeName("$diacriticSensitive");
                this.writeValue(textSearchOptions.getDiacriticSensitive());
            }
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        } else if (argName.equals("com.mongodb.client.model.Filters$OrNorFilter")) {
            this.logger.debug("writing OrNorFilter");
            String input = this.setInput(arg);
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName(input);
            this.bsonWriter.writeStartArray();
            for (Bson bsonFilter : ((FiltersGetter)arg)._$PINPOINT$_getFilters()) {
                this.writeValue(bsonFilter);
            }
            this.bsonWriter.writeEndArray();
            this.bsonWriter.writeEndDocument();
        }
    }

    private String setInput(Object arg) {
        String input = "$or/nor";
        if (arg instanceof InternalOperatorNameAccessor) {
            String op = ((InternalOperatorNameAccessor)arg)._$PINPOINT$_getInternalOperatorName();
            if (op.equals("OR")) {
                input = "$or";
            } else if (op.equals("NOR")) {
                input = "$nor";
            }
        }
        return input;
    }

    private void parseBsonObject(Object arg) {
        Map<String, ?> map = this.getBsonKeyValueMap(arg);
        if (map == null) {
            return;
        }
        this.bsonWriter.writeStartDocument();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals("_id")) continue;
            this.bsonWriter.writeName(key);
            this.writeValue(entry.getValue());
        }
        this.bsonWriter.writeEndDocument();
    }

    private void parsePrimitiveArrayObject(Object arg) {
        this.bsonWriter.writeStartArray();
        this.arrayAbbreviationForMongo(arg);
        this.bsonWriter.writeEndArray();
    }

    private <T> void parseCollection(Collection<T> arg) {
        this.bsonWriter.writeStartArray();
        this.collectionAbbreviationForMongo(arg);
        this.bsonWriter.writeEndArray();
    }

    private void parseBsonValueObject(BsonValue arg) {
        BsonType bsonType = arg.getBsonType();
        if (bsonType.equals((Object)BsonType.DOUBLE)) {
            this.writeValue(arg.asDouble().getValue());
        } else if (bsonType.equals((Object)BsonType.STRING)) {
            this.writeValue(arg.asString().getValue());
        } else if (bsonType.equals((Object)BsonType.BINARY)) {
            String abbreviatedBinary = this.binaryAbbreviationForMongo(arg);
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$binary");
            this.writeValue(abbreviatedBinary);
            this.bsonWriter.writeName("$type");
            this.writeValue(String.valueOf(String.format("%02X", arg.asBinary().getType())));
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.OBJECT_ID)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$oid");
            this.writeValue(String.valueOf(arg.asObjectId().getValue()));
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.BOOLEAN)) {
            this.writeValue(arg.asBoolean().getValue());
        } else if (bsonType.equals((Object)BsonType.DATE_TIME)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$date");
            this.writeValue(arg.asDateTime().getValue());
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.REGULAR_EXPRESSION)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$regex");
            this.writeValue(arg.asRegularExpression().getPattern());
            this.bsonWriter.writeName("$options");
            this.writeValue(arg.asRegularExpression().getOptions());
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.DB_POINTER)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$ref");
            this.writeValue(arg.asDBPointer().getNamespace());
            this.bsonWriter.writeName("$id");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$oid");
            this.writeValue(String.valueOf(arg.asDBPointer().getId()));
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.JAVASCRIPT)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$code");
            this.writeValue(arg.asJavaScript().getCode());
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.SYMBOL)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$symbol");
            this.writeValue(arg.asSymbol().getSymbol());
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.JAVASCRIPT_WITH_SCOPE)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$code");
            this.writeValue(arg.asJavaScriptWithScope().getCode());
            this.bsonWriter.writeName("$scope");
            this.writeValue(arg.asJavaScriptWithScope().getScope());
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.INT32)) {
            this.writeValue(arg.asInt32().getValue());
        } else if (bsonType.equals((Object)BsonType.TIMESTAMP)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$timestamp");
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("t");
            this.writeValue(arg.asTimestamp().getTime());
            this.bsonWriter.writeName("i");
            this.writeValue(arg.asTimestamp().getInc());
            this.bsonWriter.writeEndDocument();
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.INT64)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$numberLong");
            this.writeValue(String.valueOf(arg.asInt64().getValue()));
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.UNDEFINED)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$undefined");
            this.writeValue(true);
            this.bsonWriter.writeEndDocument();
        } else if (bsonType.equals((Object)BsonType.NULL)) {
            this.writeValue(null);
        } else if (this.decimal128Enabled && bsonType.equals((Object)BsonType.DECIMAL128)) {
            this.bsonWriter.writeStartDocument();
            this.bsonWriter.writeName("$numberDecimal");
            this.writeValue(String.valueOf(arg.asDecimal128().getValue()));
            this.bsonWriter.writeEndDocument();
        }
    }

    private Map<String, ?> getBsonKeyValueMap(Object bson) {
        if (bson instanceof BasicDBObject) {
            return (BasicDBObject)bson;
        }
        if (bson instanceof BsonDocument) {
            return (BsonDocument)bson;
        }
        if (bson instanceof Document) {
            return (Document)bson;
        }
        this.logger.debug("bson KV is null {} ", (Object)bson.getClass().getName());
        return null;
    }

    private String binaryAbbreviationForMongo(BsonValue arg) {
        byte[] binary = arg.asBinary().getData();
        int binaryLength = binary.length;
        if (binaryLength > 8) {
            return Base64.encode(binary, 0, 8) + "...(" + binaryLength + ")";
        }
        return Base64.encode(binary);
    }

    private void arrayAbbreviationForMongo(Object arg) {
        int length = Array.getLength(arg);
        for (int i = 0; i < length && i < 7; ++i) {
            this.writeValue(Array.get(arg, i));
        }
        if (length > 6) {
            this.bsonWriter.writeString("?");
            if (this.traceBsonBindValue) {
                this.jsonParameter.add("...(" + length + ")");
            }
        }
    }

    private <T> void collectionAbbreviationForMongo(Collection<T> arg) {
        int length = arg.size();
        int i = 0;
        for (T value : arg) {
            this.writeValue(value);
            if (++i <= 6) continue;
            break;
        }
        if (length > 6) {
            this.bsonWriter.writeString("?");
            if (this.traceBsonBindValue) {
                this.jsonParameter.add("...(" + length + ")");
            }
        }
    }

    private void writeValue(Object arg) {
        if (arg == null) {
            this.bsonWriter.writeString("?");
            if (this.traceBsonBindValue) {
                this.jsonParameter.add(String.valueOf(arg));
            }
        } else if (arg instanceof String) {
            this.bsonWriter.writeString("?");
            if (this.traceBsonBindValue) {
                this.jsonParameter.add("\"" + StringUtils.abbreviate((String)StringUtils.replace((String)((String)arg), (String)"\"", (String)"\"\"")) + "\"");
            }
        } else if (this.isFilter(arg)) {
            this.parseFilterObject(arg);
        } else if (this.isUpdates(arg)) {
            this.parseUpdatesObject(arg);
        } else if (this.isSort(arg)) {
            this.parseSortObject(arg);
        } else if (arg.getClass().isArray()) {
            this.parsePrimitiveArrayObject(arg);
        } else if (arg instanceof Collection) {
            this.parseCollection((Collection)arg);
        } else if (arg instanceof Bson) {
            this.parseBsonObject(arg);
        } else if (arg instanceof BsonValue) {
            this.parseBsonValueObject((BsonValue)arg);
        } else {
            this.bsonWriter.writeString("?");
            if (this.traceBsonBindValue) {
                this.jsonParameter.add(StringUtils.abbreviate((String)String.valueOf(arg)));
            }
        }
    }

    private boolean isSort(Object arg) {
        return "com.mongodb.client.model.Sorts$CompoundSort".equals(arg.getClass().getName());
    }

    private boolean isUpdates(Object arg) {
        return MongoConstants.UPDATESLIST.contains(arg.getClass().getName());
    }

    private boolean isFilter(Object arg) {
        return MongoConstants.FILTERLIST.contains(arg.getClass().getName());
    }
}

