/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.gson.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor0;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.gson.GsonConstants;

public class ToJsonInterceptor
implements AroundInterceptor0 {
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public ToJsonInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target) {
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.beforeInterceptor(target, null);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        trace.traceBlockBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object result, Throwable throwable) {
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.afterInterceptor(target, null, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordServiceType(GsonConstants.GSON_SERVICE_TYPE);
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            if (result != null && result instanceof String) {
                recorder.recordAttribute(GsonConstants.GSON_ANNOTATION_KEY_JSON_LENGTH, ((String)result).length());
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

