/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.proxy;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeader;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyHttpHeaderParser;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class ProxyHttpHeaderRecorder<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final ProxyHttpHeaderParser parser = new ProxyHttpHeaderParser();
    private final boolean enable;
    private final RequestAdaptor<T> requestAdaptor;

    public ProxyHttpHeaderRecorder(boolean enable, RequestAdaptor<T> requestAdaptor) {
        this.enable = enable;
        this.requestAdaptor = (RequestAdaptor)Assert.requireNonNull(requestAdaptor, (String)"requestAdaptor must not be null");
    }

    public void record(SpanRecorder recorder, T request) {
        block5: {
            if (recorder == null || request == null) {
                return;
            }
            if (this.enable == Boolean.FALSE) {
                if (this.isDebug) {
                    this.logger.debug("Disable record proxy http header.");
                }
                return;
            }
            try {
                this.parseAndRecord(recorder, request, Header.HTTP_PROXY_APP.toString(), 1);
                this.parseAndRecord(recorder, request, Header.HTTP_PROXY_NGINX.toString(), 2);
                this.parseAndRecord(recorder, request, Header.HTTP_PROXY_APACHE.toString(), 3);
            }
            catch (Exception e) {
                if (!this.isInfo) break block5;
                this.logger.info("Failed to record proxy http header. cause={}", (Object)e.getMessage());
            }
        }
    }

    private void parseAndRecord(SpanRecorder recorder, T request, String name, int type) {
        String value = this.requestAdaptor.getHeader(request, name);
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        ProxyHttpHeader header = this.parser.parse(type, value);
        if (header.isValid()) {
            recorder.recordAttribute(header.getAnnotationKey(), header.getAnnotationValue());
            if (this.isDebug) {
                this.logger.debug("Record proxy http header. name={}, value={}", (Object)name, (Object)value);
            }
        } else if (this.isInfo) {
            this.logger.info("Failed to parse proxy http header. name={}. value={}, cause={}", name, value, header.getCause());
        }
    }
}

