/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.MultiPackageBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.PackageInternalNameMatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@InterfaceStability.Unstable
public class DefaultMultiPackageBasedMatcher
implements MultiPackageBasedMatcher {
    private final List<String> basePackageNames;
    private final MatcherOperand matcherOperand;

    DefaultMultiPackageBasedMatcher(List<String> basePackageNames) {
        this(basePackageNames, null);
    }

    DefaultMultiPackageBasedMatcher(List<String> basePackageNames, MatcherOperand additional) {
        if (CollectionUtils.isEmpty(basePackageNames)) {
            throw new IllegalArgumentException("basePackageNames must not be empty");
        }
        List<String> buildBasePackageName = this.buildBasePackageNameList(basePackageNames);
        MatcherOperand operand = this.joinOr(buildBasePackageName);
        if (operand == null) {
            throw new IllegalStateException("operand is null");
        }
        this.matcherOperand = this.addOr(operand, additional);
        this.basePackageNames = Collections.unmodifiableList(buildBasePackageName);
    }

    private MatcherOperand addOr(MatcherOperand operand, MatcherOperand additional) {
        if (additional == null) {
            return operand;
        }
        operand = operand.and(additional);
        return operand;
    }

    private MatcherOperand joinOr(List<String> basePackageNames) {
        if (basePackageNames.isEmpty()) {
            throw new IllegalArgumentException("basePackageNames must not be empty ");
        }
        MatcherOperand operandGroup = null;
        for (String basePackageName : basePackageNames) {
            if (operandGroup == null) {
                operandGroup = new PackageInternalNameMatcherOperand(basePackageName);
                continue;
            }
            PackageInternalNameMatcherOperand packageMatcherOperand = new PackageInternalNameMatcherOperand(basePackageName);
            operandGroup = operandGroup.or(packageMatcherOperand);
        }
        return operandGroup;
    }

    private List<String> buildBasePackageNameList(List<String> basePackageNames) {
        ArrayList<String> list = new ArrayList<String>(basePackageNames.size());
        for (String basePackageName : basePackageNames) {
            if (!StringUtils.hasText((String)basePackageName)) continue;
            list.add(basePackageName);
        }
        return list;
    }

    @Override
    public List<String> getBasePackageNames() {
        return this.basePackageNames;
    }

    @Override
    public MatcherOperand getMatcherOperand() {
        return this.matcherOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMultiPackageBasedMatcher{");
        sb.append("basePackageNames=").append(this.basePackageNames);
        sb.append(", matcherOperand=").append(this.matcherOperand);
        sb.append('}');
        return sb.toString();
    }
}

