/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.profiler.ClassFileTransformerDispatcher;
import com.navercorp.pinpoint.profiler.instrument.BytecodeDumpTransformer;
import java.lang.instrument.ClassFileTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFileTransformerWrapProvider
implements Provider<ClassFileTransformer> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final Provider<ClassFileTransformerDispatcher> classFileTransformerDispatcherProvider;

    @Inject
    public ClassFileTransformerWrapProvider(ProfilerConfig profilerConfig, Provider<ClassFileTransformerDispatcher> classFileTransformerDispatcherProvider) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (classFileTransformerDispatcherProvider == null) {
            throw new NullPointerException("classFileTransformerDispatcherProvider must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.classFileTransformerDispatcherProvider = classFileTransformerDispatcherProvider;
    }

    public ClassFileTransformer get() {
        ClassFileTransformerDispatcher classFileTransformerDispatcher = (ClassFileTransformerDispatcher)this.classFileTransformerDispatcherProvider.get();
        boolean enableBytecodeDump = this.profilerConfig.readBoolean("bytecode.dump.enable", false);
        if (enableBytecodeDump) {
            this.logger.info("wrapBytecodeDumpTransformer");
            return BytecodeDumpTransformer.wrap(classFileTransformerDispatcher, this.profilerConfig);
        }
        return classFileTransformerDispatcher;
    }
}

