/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans;

import com.navercorp.pinpoint.bootstrap.util.AntPathMatcher;
import com.navercorp.pinpoint.bootstrap.util.PathMatcher;
import com.navercorp.pinpoint.bootstrap.util.RegexPathMatcher;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SpringBeansTarget {
    public static final String ANT_STYLE_PATTERN_PREFIX = "antstyle";
    public static final String REGEX_PATTERN_PREFIX = "regex";
    private SpringBeansTargetScope scope = SpringBeansTargetScope.COMPONENT_SCAN;
    private List<String> basePackages;
    private List<PathMatcher> namePatterns;
    private List<PathMatcher> classPatterns;
    private List<String> annotations;

    public boolean isValid() {
        if (CollectionUtils.hasLength(this.basePackages)) {
            return true;
        }
        if (CollectionUtils.hasLength(this.namePatterns)) {
            return true;
        }
        if (CollectionUtils.hasLength(this.classPatterns)) {
            return true;
        }
        return CollectionUtils.hasLength(this.annotations);
    }

    public void setScope(String scope) {
        this.scope = SpringBeansTargetScope.get(scope);
    }

    public SpringBeansTargetScope getScope() {
        return this.scope;
    }

    public void setBasePackages(String basePackages) {
        this.basePackages = this.split(basePackages);
    }

    public List<String> getBasePackages() {
        return this.basePackages;
    }

    public void setNamePatterns(String namePatternRegex) {
        this.namePatterns = this.compilePattern(this.split(namePatternRegex), "/");
    }

    public List<PathMatcher> getNamePatterns() {
        return this.namePatterns;
    }

    public void setClassPatterns(String classPatternRegex) {
        this.classPatterns = this.compilePattern(this.split(classPatternRegex), ".");
    }

    public List<PathMatcher> getClassPatterns() {
        return this.classPatterns;
    }

    public void setAnnotations(String annotations) {
        this.annotations = this.split(annotations);
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    List<String> split(String values) {
        if (StringUtils.isEmpty((String)values)) {
            return Collections.emptyList();
        }
        return StringUtils.tokenizeToStringList((String)values, (String)",");
    }

    List<PathMatcher> compilePattern(List<String> patternStrings, String separator) {
        if (CollectionUtils.isEmpty(patternStrings)) {
            return null;
        }
        ArrayList<PathMatcher> pathMatchers = new ArrayList<PathMatcher>(patternStrings.size());
        for (String patternString : patternStrings) {
            int prefixEnd = patternString.indexOf(":");
            if (prefixEnd != -1) {
                String trimmed;
                String prefix = patternString.substring(0, prefixEnd).trim();
                if (prefix.equals(ANT_STYLE_PATTERN_PREFIX)) {
                    trimmed = patternString.substring(prefixEnd + 1).trim();
                    if (trimmed.isEmpty()) continue;
                    pathMatchers.add((PathMatcher)new AntPathMatcher(trimmed, separator));
                    continue;
                }
                if (prefix.equals(REGEX_PATTERN_PREFIX)) {
                    trimmed = patternString.substring(prefixEnd + 1).trim();
                    if (trimmed.isEmpty()) continue;
                    Pattern pattern = Pattern.compile(trimmed);
                    pathMatchers.add((PathMatcher)new RegexPathMatcher(pattern));
                    continue;
                }
            }
            Pattern pattern = Pattern.compile(patternString);
            pathMatchers.add((PathMatcher)new RegexPathMatcher(pattern));
        }
        return pathMatchers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("scope=").append((Object)this.scope);
        sb.append(", basePackages=").append(this.basePackages);
        sb.append(", namePatterns=").append(this.namePatterns);
        sb.append(", classPatterns=").append(this.classPatterns);
        sb.append(", annotations=").append(this.annotations);
        sb.append('}');
        return sb.toString();
    }
}

