#!/bin/sh
sql_file_folder=./sql_to_run

set -e
set -x

# Start the MySQL daemon in the background.
/usr/sbin/mysqld &
mysql_pid=$!

until mysqladmin ping &>/dev/null; do
  echo -n "."; sleep 0.2
done

# Permit root login without password from outside container.
mysql -e "GRANT ALL ON *.* TO qa@'%' IDENTIFIED BY 'qatest' WITH GRANT OPTION"

echo "cd $sql_file_folder"
cd $sql_file_folder

for entry in ./*
do
	echo "run sql file: $entry"
	mysql < $entry
done

# Tell the MySQL daemon to shutdown.
mysqladmin shutdown

# Wait for the MySQL daemon to exit.
wait $mysql_pid

sh /etc/init.d/mysql restart