/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter;

import com.tapm.starter.util.Resolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class OneAgentInfo {
    public static OneAgentInfo DUMMY_ONEAGENT_INFO = new OneAgentInfo(null, null, null, null);
    private final File oneAgentPath;
    private final File oneAgentConfigFile;
    private final Map<String, Object> oneAgentConfig;
    private final String oneAgentUUID;

    public OneAgentInfo(File oneAgentPath, File oneAgentConfigFile, Map<String, Object> oneAgentConfig, String uuid) {
        this.oneAgentPath = oneAgentPath;
        this.oneAgentConfig = oneAgentConfig;
        this.oneAgentUUID = uuid;
        this.oneAgentConfigFile = oneAgentConfigFile;
    }

    public File getOneAgentPath() {
        return this.oneAgentPath;
    }

    public Map<String, Object> getOneAgentConfig() {
        return this.oneAgentConfig;
    }

    public File getOneAgentConfigFile() {
        return this.oneAgentConfigFile;
    }

    public String getOneAgentUUID() {
        return this.oneAgentUUID;
    }

    public boolean isOneAgentMode() {
        return this.oneAgentConfig != null;
    }

    public static OneAgentInfo getOneAgentInfo(File agentPath) {
        try {
            File oneAgentConfigPath = null;
            File parent = agentPath.getParentFile();
            if (parent != null && parent.exists() && (parent = parent.getParentFile()) != null && parent.exists()) {
                oneAgentConfigPath = new File(parent.getAbsolutePath(), "conf");
            }
            if (oneAgentConfigPath != null && oneAgentConfigPath.exists()) {
                File oneAgentConfigFile = new File(oneAgentConfigPath, "oneagent.conf");
                File oneAgentJavaConfigFile = new File(oneAgentConfigPath, "java.conf");
                if (oneAgentConfigFile.exists()) {
                    Map<String, Object> oneAgentConf = OneAgentInfo.loadOneAgentConf(oneAgentConfigFile);
                    if (oneAgentJavaConfigFile.exists()) {
                        OneAgentInfo.loadOneAgentJavaConf(oneAgentJavaConfigFile, oneAgentConf);
                    }
                    String oneAgentUUID = OneAgentInfo.getOneAgentUUID(oneAgentConfigPath);
                    return new OneAgentInfo(oneAgentConfigPath.getParentFile(), oneAgentConfigFile, oneAgentConf, oneAgentUUID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to get OneAgent config");
        }
        return DUMMY_ONEAGENT_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadOneAgentJavaConf(File oneAgentJavaConfigFile, Map<String, Object> oneAgentConf) {
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(oneAgentJavaConfigFile);
            properties.load(input);
            Properties resolverProperties = OneAgentInfo.loadResolverProperties(properties);
            for (Map.Entry<Object, Object> entry : resolverProperties.entrySet()) {
                if (oneAgentConf.containsKey(entry.getKey())) continue;
                oneAgentConf.put(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        catch (Exception e) {
            System.err.println("Agent Starter loadOneAgentConfOfJava found exception :" + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOneAgentUUID(File oneAgentConfPath) throws IOException {
        File oneAgentUUIDFile = new File(oneAgentConfPath, "oneagent.uuid");
        if (oneAgentUUIDFile.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(oneAgentUUIDFile));
                String uuid = bufferedReader.readLine().trim();
                String string = uuid.length() == 0 ? null : uuid;
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadOneAgentConf(File oneAgentConfigFile) {
        Properties properties = new Properties();
        HashMap<String, Object> oneAgentConfigMap = new HashMap<String, Object>();
        FileInputStream input = null;
        try {
            String collectors;
            input = new FileInputStream(oneAgentConfigFile);
            properties.load(input);
            Properties resolverProperties = OneAgentInfo.loadResolverProperties(properties);
            String license_key = resolverProperties.getProperty("license_key", "");
            if (license_key != null && license_key.length() > 0) {
                oneAgentConfigMap.put("license_key", license_key);
            }
            if ((collectors = resolverProperties.getProperty("collectors", "")) != null && collectors.length() > 0) {
                oneAgentConfigMap.put("collector.addresses", collectors);
            }
            String host = resolverProperties.getProperty("network_proxy.host", "");
            String port = resolverProperties.getProperty("network_proxy.port", "");
            String user = resolverProperties.getProperty("network_proxy.user", "");
            String password = resolverProperties.getProperty("network_proxy.password", "");
            if (host != null && host.length() > 0) {
                oneAgentConfigMap.put("proxy_host", host);
            }
            if (port != null && port.length() > 0) {
                oneAgentConfigMap.put("proxy_port", port);
            }
            if (user != null && user.length() > 0) {
                oneAgentConfigMap.put("proxy_user", user);
            }
            if (password != null && password.length() > 0) {
                oneAgentConfigMap.put("proxy_password", password);
            }
        }
        catch (Exception e) {
            System.err.println("Agent Starter loadOneAgentConf found exception :" + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return oneAgentConfigMap;
    }

    private static Properties loadResolverProperties(Properties properties) {
        Properties resolverProperties = new Properties();
        Resolver resolver = new Resolver(true);
        Set<Object> propertyNames = properties.keySet();
        for (Object name : propertyNames) {
            if (!(name instanceof String)) continue;
            String value = properties.getProperty((String)name);
            Object valueObj = resolver.resolverValue(value);
            resolverProperties.put((String)name, valueObj);
        }
        return resolverProperties;
    }
}

