#!/bin/bash
echo "java_start java"
module_name=project
package_path="`pwd`${module_name}/app.jar"
config_path="`pwd`${module_name}/application.properties"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"
sed -i "s/.xyqb.com/-$NAMESPACE.q-gp.com/g" ${config_path}
sed -i "s/.domain.com/-$NAMESPACE.q-gp.com/g" ${config_path}

sed -i "s/xterm.js demo/${SYSTEM_NAME}@${NAMESPACE}/"  /home/qg-xterm/demo/index.html

echo "nohup java -Xmx512m -XX:PermSize64m -XX:MaxMetaspaceSize=128m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} &" > java_command
nohup java -Xmx512m -XX:PermSize64m -XX:MaxMetaspaceSize=128m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} &

echo "sleep 10"
sleep 10

if ls ./*log 1> /dev/null 2>&1; then
    echo "ls -l ./logs"
    ls -l ./logs    
else
    echo "files do not exist"
    touch ./logs/tmp.log
fi

echo "cd /home/qg-xterm/;git pull;cd -"
cd /home/qg-xterm/;git pull;cd -

echo "node /home/qg-xterm/demo/app.js"
nohup node /home/qg-xterm/demo/app.js &

echo "frontail logs/*.log -d -n 300"
frontail ./logs/*log -n 300