/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.akka.http;

import akka.http.javadsl.model.Host;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.Uri;
import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.akka.http.AkkaHttpConfig;
import java.util.Optional;

public class HttpRequestAdaptor
implements RequestAdaptor<HttpRequest> {
    private static final String UNKNOWN = "Unknown";
    private static final String DEFAULT_REMOTE_ADDRESS_HEADER = "Remote-Address";
    private final String remoteAddressHeader;

    public HttpRequestAdaptor(AkkaHttpConfig config) {
        this.remoteAddressHeader = this.getRealIpHeader(config);
    }

    private String getRealIpHeader(AkkaHttpConfig config) {
        String realIpHeader = config.getRealIpHeader();
        if (StringUtils.isEmpty((String)realIpHeader)) {
            return DEFAULT_REMOTE_ADDRESS_HEADER;
        }
        return realIpHeader;
    }

    public String getHeader(HttpRequest request, String name) {
        return this.getHeader(request, name, null);
    }

    private String getHeader(HttpRequest request, String name, String defaultValue) {
        if (request == null) {
            return defaultValue;
        }
        Optional optional = request.getHeader(name);
        if (optional == null) {
            return defaultValue;
        }
        HttpHeader header = optional.orElse(null);
        if (header == null) {
            return defaultValue;
        }
        String value = header.value();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getRpcName(HttpRequest request) {
        Uri uri = request.getUri();
        if (this.validateRpcName(uri)) {
            return uri.getPathString();
        }
        return UNKNOWN;
    }

    private boolean validateRpcName(Uri uri) {
        if (uri == null) {
            return false;
        }
        return StringUtils.hasText((String)uri.getPathString());
    }

    public String getEndPoint(HttpRequest request) {
        Uri uri = request.getUri();
        if (this.validateEndPoint(uri)) {
            Host host = uri.getHost();
            return HostAndPort.toHostAndPortString((String)host.address(), (int)uri.getPort());
        }
        return UNKNOWN;
    }

    private boolean validateEndPoint(Uri uri) {
        if (uri == null) {
            return false;
        }
        Host host = uri.getHost();
        if (host == null) {
            return false;
        }
        String hostAddress = host.address();
        return StringUtils.hasText((String)hostAddress);
    }

    public String getRemoteAddress(HttpRequest request) {
        return this.getHeader(request, this.remoteAddressHeader, "");
    }

    public String getAcceptorHost(HttpRequest request) {
        return this.getHeader(request, Header.HTTP_HOST.toString());
    }
}

