/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matchers;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformOperations;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;

@InterfaceStability.Unstable
public class MatchableTransformTemplate
implements TransformOperations {
    private final InstrumentContext instrumentContext;

    public MatchableTransformTemplate(InstrumentContext instrumentContext) {
        if (instrumentContext == null) {
            throw new NullPointerException("instrumentContext must not be null");
        }
        this.instrumentContext = instrumentContext;
    }

    @Override
    public void transform(String className, TransformCallback transformCallback) {
        Assert.requireNonNull((Object)className, (String)"className must not be null");
        Assert.requireNonNull((Object)transformCallback, (String)"transformCallback must not be null");
        Matcher matcher = Matchers.newClassNameMatcher(className);
        this.instrumentContext.addClassFileTransformer(matcher, transformCallback);
    }

    public void transform(Matcher matcher, TransformCallback transformCallback) {
        Assert.requireNonNull((Object)matcher, (String)"matcher must not be null");
        Assert.requireNonNull((Object)transformCallback, (String)"transformCallback must not be null");
        this.instrumentContext.addClassFileTransformer(matcher, transformCallback);
    }
}

