/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operator;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.MatcherOperator;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;

@InterfaceStability.Unstable
public class OrMatcherOperator
extends AbstractMatcherOperand
implements MatcherOperator {
    private final MatcherOperand leftOperand;
    private final MatcherOperand rightOperand;

    public OrMatcherOperator(MatcherOperand leftOperand, MatcherOperand rightOperand) {
        this.leftOperand = (MatcherOperand)Assert.requireNonNull((Object)leftOperand, (String)"leftOperand must not be null");
        this.rightOperand = (MatcherOperand)Assert.requireNonNull((Object)rightOperand, (String)"rightOperand must not be null");
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    @Override
    public int getExecutionCost() {
        return this.leftOperand.getExecutionCost() + this.rightOperand.getExecutionCost();
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public MatcherOperand getLeftOperand() {
        return this.leftOperand;
    }

    @Override
    public MatcherOperand getRightOperand() {
        return this.rightOperand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.leftOperand);
        sb.append(" OR ");
        sb.append(this.rightOperand).append(")");
        return sb.toString();
    }
}

