/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.logback.interceptor;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor0;
import org.slf4j.MDC;

public class LoggingEventOfLogbackInterceptor
implements AroundInterceptor0 {
    private static final String TRANSACTION_ID = "PtxId";
    private static final String SPAN_ID = "PspanId";
    private final TraceContext traceContext;

    public LoggingEventOfLogbackInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void before(Object target) {
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            MDC.remove((String)TRANSACTION_ID);
            MDC.remove((String)SPAN_ID);
            return;
        }
        MDC.put((String)TRANSACTION_ID, (String)trace.getTraceId().getTransactionId());
        MDC.put((String)SPAN_ID, (String)String.valueOf(trace.getTraceId().getSpanId()));
    }

    public void after(Object target, Object result, Throwable throwable) {
    }
}

