/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3Constants;

public class RetryMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;

    public RetryMethodInterceptor(TraceContext context, MethodDescriptor methodDescriptor) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor must not be null");
        }
        this.traceContext = context;
        this.descriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(HttpClient3Constants.HTTP_CLIENT_3_INTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            String retryMessage = this.getRetryMessage(args);
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, retryMessage);
            if (result != null) {
                recorder.recordAttribute(AnnotationKey.RETURN_DATA, result);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getRetryMessage(Object[] args) {
        if (args == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (args.length >= 2 && args[1] instanceof Exception) {
            sb.append(args[1].getClass().getName()).append(", ");
        }
        if (args.length >= 3 && args[2] instanceof Integer) {
            sb.append(args[2]);
        }
        return sb.toString();
    }
}

