/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.util.SocketAddressUtils;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConstants;
import java.net.InetSocketAddress;

public class HbaseClientMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HbaseClientMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(HbasePluginConstants.HBASE_CLIENT);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        String endPoint = this.getEndPoint(args);
        recorder.recordEndPoint(endPoint != null ? endPoint : "Unknown");
        recorder.recordDestinationId("HBASE");
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordException(throwable);
    }

    protected String getEndPoint(Object[] args) {
        if (args != null && args.length == 7 && args[5] instanceof InetSocketAddress) {
            return SocketAddressUtils.getHostNameFirst((InetSocketAddress)((InetSocketAddress)args[5]));
        }
        return null;
    }
}

