/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.classloader;

import com.navercorp.pinpoint.common.util.ClassUtils;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.test.classloader.TestClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestClassLoaderFactory.class);
    private static final String CENQUA_CLOVER = "com_cenqua_clover.Clover";
    private static final String ATLASSIAN_CLOVER = "com_atlassian_clover.Clover";

    public static TestClassLoader createTestClassLoader(DefaultApplicationContext applicationContext) {
        TestClassLoader testClassLoader = new TestClassLoader(applicationContext);
        TestClassLoaderFactory.addCloverPackage(testClassLoader, CENQUA_CLOVER);
        TestClassLoaderFactory.addCloverPackage(testClassLoader, ATLASSIAN_CLOVER);
        return testClassLoader;
    }

    private static void addCloverPackage(TestClassLoader testClassLoader, String className) {
        String packageName = TestClassLoaderFactory.getPackageName(className);
        testClassLoader.addDelegateClass(packageName);
    }

    private static String getPackageName(String className) {
        return ClassUtils.getPackageName((String)className) + ".";
    }
}

