/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.async;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matchers;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.MatchableTransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.spring.async.SpringAsyncConfig;
import java.security.ProtectionDomain;
import java.util.List;

public class SpringAsyncPlugin
implements ProfilerPlugin,
MatchableTransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private MatchableTransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        SpringAsyncConfig config = new SpringAsyncConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("Disable SpringAsyncPlugin");
            return;
        }
        this.logger.info("SpringAsyncPlugin config={}", (Object)config);
        this.addAsyncExecutionInterceptorTask(Matchers.newClassNameMatcher((String)"org.springframework.aop.interceptor.AsyncExecutionInterceptor$1"));
        this.addAsyncExecutionInterceptorTask(Matchers.newPackageBasedMatcher((String)"org.springframework.aop.interceptor.AsyncExecutionInterceptor$$Lambda$"));
        List<String> asyncTaskExecutorClassNameList = config.getAsyncTaskExecutorClassNameList();
        for (String className : asyncTaskExecutorClassNameList) {
            if (StringUtils.isEmpty((String)className)) continue;
            this.addAsyncTaskExecutor(className);
        }
    }

    private void addAsyncExecutionInterceptorTask(Matcher matcher) {
        this.transformTemplate.transform(matcher, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod callMethod = target.getDeclaredMethod("call", new String[0]);
                if (callMethod != null) {
                    callMethod.addInterceptor("com.navercorp.pinpoint.plugin.spring.async.interceptor.TaskCallInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addAsyncTaskExecutor(String className) {
        this.transformTemplate.transform(className, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod submitMethod = target.getDeclaredMethod("submit", new String[]{"java.util.concurrent.Callable"});
                if (submitMethod != null) {
                    submitMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.spring.async.interceptor.AsyncTaskExecutorSubmitInterceptor", "AsyncTaskExecutorScope");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(MatchableTransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

