/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.jedis.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.redis.jedis.EndPointAccessor;
import redis.clients.jedis.Client;

public class AttachEndPointInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public AttachEndPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        try {
            if (!this.validate(target, args)) {
                return;
            }
            String endPoint = ((EndPointAccessor)args[0])._$PINPOINT$_getEndPoint();
            if (endPoint != null) {
                ((EndPointAccessor)target)._$PINPOINT$_setEndPoint(endPoint);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null || args.length == 0 || args[0] == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid arguments. Null or not found args({}).", args);
            }
            return false;
        }
        if (!(args[0] instanceof Client)) {
            if (this.isDebug) {
                this.logger.debug("Invalid arguments. Expect Client but args[0]({}).", args[0]);
            }
            return false;
        }
        if (!(args[0] instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. Need field accessor({}).", (Object)EndPointAccessor.class.getName());
            }
            return false;
        }
        if (!(target instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)EndPointAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
    }
}

